/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lineTypeElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.app.main;
import sumo.gui.AbstractLine;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.ResourceDetail;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.project.Project;
import sumoTween.Tweener;

public class guiResource
extends JPanel
implements guiLineTypeIF {
    KeyframedResource theResource;
    private boolean mouseOver = false;
    private boolean mode = false;
    Color bgColor = Settings.lineBackground;
    guiStopWatch watch = null;
    KeyFramePanel sp = null;
    AbstractLine abstractLine = null;

    public Component getComponent() {
        return this;
    }

    public guiResource(KeyframedResource keyframedResource) {
        this.theResource = keyframedResource;
        this.theResource.guiResource = this;
        this.setBounds(new Rectangle(100, 16));
        this.theResource.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                guiResource.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                guiResource.this.mouseOver = true;
                guiResource.this.setCursor(Cursor.getPredefinedCursor(12));
                guiResource.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                guiResource.this.mouseOver = false;
                guiResource.this.setCursor(Cursor.getPredefinedCursor(0));
                guiResource.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                if (guiResource.this.theResource.getResource() == null) {
                    guiResource.this.mode = !guiResource.this.mode;
                    if (guiResource.this.mode) {
                        Project.getProject().getResourceManager().setActiveResourceSelect(guiResource.this.theResource);
                        Project.getProject().setDetailPanel(new ResourceDetail(guiResource.this.theResource, Project.getProject().getDetailPanel()));
                    } else {
                        Project.getProject().getResourceManager().removeActiveResourceSelect(guiResource.this.theResource);
                        Project.getProject().setDetailPanel(null);
                    }
                    guiResource.this.repaint();
                } else if (e.getX() < guiResource.this.getWidth() - 20) {
                    main.gui.showResourceDetail(guiResource.this.theResource.getResource());
                } else {
                    Project.getProject().getResourceManager().setActiveResourceSelect(guiResource.this.theResource);
                    Project.getProject().setDetailPanel(new ResourceDetail(guiResource.this.theResource, Project.getProject().getDetailPanel()));
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_GUIRESOURCE);
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setFont(Settings.smallfont);
        gd.setColor(Settings.lineBackground);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
        if (this.mode) {
            gd.setColor(Settings.mainColor1);
            gd.fillRect(18, 2, this.getWidth(), this.getHeight() - 4);
            gd.setColor(Color.white);
        } else {
            gd.setColor(Color.black);
        }
        if (this.theResource != null) {
            if (this.theResource.getResource() == null) {
                gd.drawString("-", 20, 12);
            } else {
                Icons.drawIcon(gd, this.theResource.getResource().getIcon(), 1, 1);
                gd.drawString(this.theResource.getResource().getFilename(), 20, 12);
            }
        } else {
            gd.drawString("none", 2, 12);
        }
        Icons.drawIcon(gd, Icons.ICON_FOLDER, this.getWidth() - 18, 0);
        gd.setColor(Color.WHITE);
        gd.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public boolean isKeyframeAble() {
        return false;
    }

    public boolean isKeyFramed() {
        return false;
    }

    public void setIsKeyFramed(boolean b) {
    }

    public void setKeyframePanel(KeyFramePanelIF kf) {
    }

    public void setMarked(boolean b) {
        this.mode = b;
        this.repaint();
    }

    public Tweener getKeyframed() {
        return null;
    }

    public KeyFramePanelIF getKeyFramePanel(ScenePanel p) {
        if (this.sp == null) {
            this.sp = new KeyFramePanel(p);
        }
        return this.sp;
    }

    public void setAbstractLine(AbstractLine al) {
        this.abstractLine = al;
    }

    public void setEnableDisableSwitch(boolean parseBoolean) {
    }

    public boolean getEnableDisableSwitch() {
        return false;
    }
}

