/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.KeyDetail;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyIF;
import sumo.math.vec2i;
import sumo.project.Project;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.Linear;

public class KeyFramePanelTweener
extends JPanel
implements KeyFramePanelIF {
    public static boolean ignoreMouse = false;
    public static boolean usingMouse = false;
    private ScenePanel sp;
    Color bg = Color.red;
    private Object[] keys;
    private boolean mouseOver = false;
    private boolean mouseDown = false;
    private boolean mouseDragged = false;
    int mouseX = -999;
    int mouseY = -999;
    guiStopWatch watch = null;
    private int lastValue = 0;
    private int lastX = 0;
    private KeyFramedIF keyframed;
    private int tempPosition;
    vec2i markedAreaStart;
    vec2i markedAreaEnd;
    private Tweener tweener;

    public KeyFramePanelTweener(ScenePanel s) {
        this.sp = s;
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (!ignoreMouse) {
                    if (!KeyFramePanelTweener.this.mouseDragged && KeyFramePanelTweener.this.mouseOverKey(e.getX()) != null) {
                        KeyFramePanelTweener.this.mouseDragged = true;
                    }
                    if (KeyFramePanelTweener.this.mouseDragged) {
                        KeyFramePanelTweener.this.sp.moveMarkedKeys(KeyFramePanelTweener.this.sp.getTimeFromPixelScreen(e.getX()).floatValue());
                    }
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (KeyFramePanelTweener.this.keys != null) {
                    KeyFramePanelTweener.this.mouseX = e.getX();
                    KeyFramePanelTweener.this.mouseY = e.getY();
                    KeyFramePanelTweener.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                if (KeyFramePanelTweener.this.keys != null && KeyFramePanelTweener.this.keys.length > 0) {
                    KeyFramePanelTweener.this.mouseOver = true;
                    KeyFramePanelTweener.this.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                KeyFramePanelTweener.this.mouseOver = false;
                KeyFramePanelTweener.this.mouseX = -999;
                KeyFramePanelTweener.this.mouseY = -999;
                if (KeyFramePanelTweener.this.keys != null && KeyFramePanelTweener.this.keys.length > 0) {
                    KeyFramePanelTweener.this.repaint();
                }
            }

            public void mousePressed(MouseEvent e) {
                KeyIF k = KeyFramePanelTweener.this.mouseOverKey(e.getX());
                if (k != null) {
                    usingMouse = true;
                    if (!((KeyFramePanelTweener)KeyFramePanelTweener.this).sp.markedKeys.contains(k)) {
                        KeyFramePanelTweener.this.sp.resetMarkedKeys();
                        KeyFramePanelTweener.this.sp.addMarkedKey(k);
                    }
                }
                KeyFramePanelTweener.this.mouseDown = true;
                KeyFramePanelTweener.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                KeyFramePanelTweener.this.mouseDown = false;
                ((KeyFramePanelTweener)KeyFramePanelTweener.this).sp.keyDraggStartTime = -9999.0f;
                KeyFramePanelTweener.this.repaint();
                usingMouse = false;
                if (!KeyFramePanelTweener.this.mouseDragged && KeyFramePanelTweener.this.keys != null) {
                    for (int i = 0; i < KeyFramePanelTweener.this.keys.length; ++i) {
                        KeyIF k = (KeyIF)KeyFramePanelTweener.this.keys[i];
                        int x = KeyFramePanelTweener.this.sp.getTimeInPixel(k.getTime());
                        if (e.getX() < x + 16 && e.getX() > x - 2 && !KeyFramePanelTweener.this.mouseDragged) {
                            KeyFramePanelTweener.this.sp.resetMarkedKeys();
                            KeyFramePanelTweener.this.sp.addMarkedKey((KeyIF)KeyFramePanelTweener.this.keys[i]);
                            Project.getProject().setDetailPanel(new KeyDetail(((KeyFramePanelTweener)KeyFramePanelTweener.this).sp.markedKeys, KeyFramePanelTweener.this.sp));
                        }
                        KeyFramePanelTweener.this.repaint();
                    }
                }
                KeyFramePanelTweener.this.mouseDragged = false;
            }
        });
    }

    private KeyIF mouseOverKey(int xx) {
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                KeyIF k = (KeyIF)this.keys[i];
                int x = this.sp.getTimeInPixelsScreen(k.getTime());
                if (xx >= x + 8 || xx <= x - 8) continue;
                return k;
            }
        }
        return null;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_KEYFRAMEPANEL);
        }
        Graphics2D gd = (Graphics2D)g;
        this.lastValue = 0;
        this.lastX = 0;
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(Settings.borderColor);
        g.drawLine(0, 0, 0, this.getHeight());
        g.setColor(Settings.timing_cursor);
        int x = this.sp.getTimeInPixelsScreen(Project.getProject().getTime());
        g.drawLine(x, 0, x, this.getHeight());
        int lastx = 0;
        int lasty = 0;
        g.setColor(Color.red);
        for (float t = this.sp.getTimeFromPixelScreen(-10).floatValue(); t < this.sp.getTimeFromPixelScreen(this.getWidth()).floatValue(); t += 0.1f) {
            int dy = (int)(this.tweener.getNormalizedValue(t) * (float)this.getHeight() - 1.0f);
            int dx = this.sp.getTimeInPixelsScreen(t);
            g.drawLine(lastx, lasty, dx, dy);
            lastx = dx;
            lasty = dy;
        }
        if (this.tweener == null) {
            System.out.println("tweener null!!");
        } else {
            for (int i = 0; i < this.tweener.getKeys().length; ++i) {
                KeyFloat f = this.tweener.getKeyByIndex(i);
                this.drawKey(g, f, f.getTime(), (int)(f.getInternalValue() * (float)this.getHeight() - 6.0f) + 3);
            }
        }
        if (this.markedAreaStart != null) {
            g.setColor(new Color(0.3f, 0.3f, 0.3f, 0.3f));
            g.fillRect(this.markedAreaStart.getX(), 0, this.markedAreaEnd.getX(), 17);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private boolean drawKey(Graphics g, KeyFloat k, float time, int valueScreen) {
        boolean ret = false;
        int x = this.sp.getTimeInPixelsScreen(time) - 4;
        if (this.sp.isTimeVisible(time)) {
            if (this.mouseX < x + 8 && this.mouseX > x - 3 && !this.mouseDragged) {
                g.setColor(Settings.mainColor1);
                g.fillRoundRect(x - 2, 1, 12, this.getHeight() - 2, 4, 4);
                ret = true;
            }
            int icon_in = Icons.KEY_IN_BEZIER;
            int icon_out = Icons.KEY_OUT_BEZIER;
            if (k.getEasing() instanceof Linear) {
                icon_in = Icons.KEY_IN_LINEAR;
                icon_out = Icons.KEY_OUT_LINEAR;
            }
            if (k.getEasingDirection() == 3) {
                icon_in = Icons.KEY_IN_ABSOLUT;
                icon_out = Icons.KEY_OUT_ABSOLUT;
            }
            int y = 3;
            if (this.getHeight() > 17) {
                y = (int)((float)(this.getHeight() - 6) * k.getInternalValue() - 3.0f);
            }
            Icons.drawIcon(g, icon_in, x - 1, y);
            Icons.drawIcon(g, icon_out, x + 4, y);
        }
        this.lastX = x;
        this.lastValue = valueScreen;
        return ret;
    }

    public void setBg(Color bg) {
        this.bg = bg;
    }

    public void setkeys(KeyFramedIF keys) {
        this.keyframed = keys;
        this.keys = keys.getKeyframingEnabled() ? this.keyframed.getKeys() : null;
    }

    public int getTempPosition() {
        return this.tempPosition;
    }

    public void setTempPosition(int count) {
        this.tempPosition = count;
    }

    public void setMarkedArea(int i, int j, int k, int l) {
        this.markedAreaStart = new vec2i(i, j);
        this.markedAreaEnd = new vec2i(k, l);
        this.repaint();
    }

    public void resetMarkedArea() {
        this.markedAreaEnd = null;
        this.markedAreaStart = null;
        this.repaint();
    }

    public KeyIF[] getKeys() {
        return (KeyIF[])this.keys;
    }

    public void setkeys(Tweener tweener) {
        this.tweener = tweener;
    }
}

