/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.app.main;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.project.Project;
import sumo.util.Files;

public class timeControlPanel
extends JPanel {
    int DISPLAY_MINUTES = 1;
    int DISPLAY_SECONDS = 0;
    int DISPLAY_FRAMES = 2;
    int displayMode = 0;
    int buttony = 10;
    String stime = "";
    Button but_play;
    private ScenePanel scenePanel;
    guiStopWatch watch = null;
    public long lastpaint = 0L;

    public timeControlPanel(ScenePanel s) {
        this.scenePanel = s;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
                ++timeControlPanel.this.displayMode;
                if (timeControlPanel.this.displayMode > 2) {
                    timeControlPanel.this.displayMode = 0;
                }
                timeControlPanel.this.repaint();
            }
        });
        this.setBounds(10, -5, 200, 30);
        this.setBackground(Settings.lineTitleBackground);
        this.setLayout(null);
        int buttonsX = 10;
        Icons.init(this.getClass());
        Button but_reset = new Button(Icons.ICON_TIME_RESET, "reset");
        this.add(but_reset);
        but_reset.setPosition(buttonsX, this.buttony);
        Button but_rew = new Button(Icons.ICON_TIME_REWIND, "rewind");
        this.add(but_rew);
        but_rew.setPosition(buttonsX += 20, this.buttony);
        this.but_play = new Button(Icons.ICON_TIME_PLAY, "play");
        this.add(this.but_play);
        this.but_play.setPosition(buttonsX += 20, this.buttony);
        Button but_ffw = new Button(Icons.ICON_TIME_FORWARD, "forward");
        this.add(but_ffw);
        but_ffw.setPosition(buttonsX += 20, this.buttony);
        buttonsX += 20;
        Button but_screenshot = new Button(Icons.ICON_SCREENSHOT, "screenshot");
        this.add(but_screenshot);
        but_screenshot.setPosition(300, this.buttony);
        buttonsX += 20;
        but_screenshot.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                Rectangle rectangle = new Rectangle(main.gui.getBounds());
                String fn = System.getProperty("java.io.tmpdir") + System.currentTimeMillis() + ".png";
                guitest.screenshot(fn, rectangle);
                Files.uploadScreenshot(fn);
                Project.setStatus("screenshot of window uploaded... (drastic.net/work/autosumo/)");
            }
        });
        but_reset.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                Project.getProject().getTimer().setTime(0.0f);
                timeControlPanel.this.scenePanel.repaintTimings();
                timeControlPanel.this.repaint();
            }
        });
        but_ffw.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                Project.getProject().getTimer().setTime(Project.getProject().getTime() + 1.0f);
                timeControlPanel.this.scenePanel.repaintTimings();
                timeControlPanel.this.repaint();
            }
        });
        but_rew.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                Project.getProject().getTimer().setTime(Project.getProject().getTime() - 1.0f);
                timeControlPanel.this.scenePanel.repaintTimings();
                timeControlPanel.this.repaint();
            }
        });
        this.but_play.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (Project.getProject().getTimer().isPlaying()) {
                    Project.getProject().getTimer().pause();
                    Project.getProject().setTime(Float.valueOf(Project.getProject().getTimer().getTime()));
                    timeControlPanel.this.but_play.setIcon(Icons.ICON_TIME_PLAY);
                    timeControlPanel.this.scenePanel.repaintTimings();
                } else {
                    Project.getProject().getTimer().play();
                    timeControlPanel.this.but_play.setIcon(Icons.ICON_TIME_PAUSE);
                    timeControlPanel.this.scenePanel.repaintTimings();
                }
                timeControlPanel.this.repaint();
            }
        });
    }

    public void paint(Graphics g) {
        this.lastpaint = System.currentTimeMillis();
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_TIMECONTROLPANEL);
        }
        Graphics2D gd = (Graphics2D)g;
        g.setColor(Settings.borderColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(Settings.verybigfont);
        g.setColor(Settings.pluginTitleColor);
        if (this.displayMode == this.DISPLAY_SECONDS) {
            this.stime = String.valueOf((float)Math.round(Project.getProject().getTimer().getTime() * 100.0f) / 100.0f) + "";
        } else if (this.displayMode == this.DISPLAY_MINUTES) {
            int minutes = (int)(Project.getProject().getTimer().getTime() / 60.0f);
            int seconds = (int)Project.getProject().getTimer().getTime() - minutes * 60;
            float mss = Project.getProject().getTimer().getTime() - (float)seconds - (float)(minutes * 60);
            int ms = (int)(mss * 100.0f);
            this.stime = "" + minutes + ":" + seconds + "." + ms;
        } else if (this.displayMode == this.DISPLAY_FRAMES) {
            float step = 1.0f / (float)Project.getProject().getFPS();
            int frame = (int)Math.ceil(Project.getProject().getTime() / step);
            this.stime = String.valueOf(frame);
        }
        g.drawString(this.stime, 100, this.buttony + 14);
        this.paintComponents(g);
        if (Project.getProject().debugGUI) {
            gd.setFont(Settings.smallfont);
            gd.setColor(Color.blue);
            gd.drawString(this.getClass().getName(), 10, 15);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }
}

