/*
 * Decompiled with CFR 0.152.
 */
package sumo.input.midi;

import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import sumo.gui.dialogs.exceptionDialog;
import sumo.input.midi.MidiBindingIF;
import sumo.input.midi.MidiListener;
import sumo.input.midi.MidiReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiController {
    ArrayList<MidiBindingIF> bindings = new ArrayList();
    private ArrayList<MidiListener> midiListener = new ArrayList();
    Receiver recout;
    MidiReceiver r;
    Transmitter t;

    public void addBinding(MidiBindingIF b) {
        this.bindings.add(b);
    }

    public MidiBindingIF getBinding(Object o) {
        for (MidiBindingIF binding : this.bindings) {
            if (binding.getObj() != o) continue;
            return binding;
        }
        return null;
    }

    public static ArrayList<String> getAvailableControllers(boolean input) {
        ArrayList<String> controllers = new ArrayList<String>();
        boolean bForInput = true;
        boolean bForOutput = true;
        boolean bVerbose = true;
        MidiDevice.Info[] aInfos = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < aInfos.length; ++i) {
            try {
                boolean bAllowsOutput;
                MidiDevice device = MidiSystem.getMidiDevice(aInfos[i]);
                boolean bAllowsInput = device.getMaxTransmitters() != 0;
                boolean bl = bAllowsOutput = device.getMaxReceivers() != 0;
                if ((!bAllowsInput || !bForInput) && (!bAllowsOutput || !bForOutput)) continue;
                if (bVerbose) {
                    if ((!input || !bAllowsInput) && (input || !bAllowsOutput)) continue;
                    controllers.add("" + i + "  " + (bAllowsInput ? "IN " : "   ") + (bAllowsOutput ? "OUT " : "    ") + aInfos[i].getName() + ", " + aInfos[i].getVendor() + ", " + aInfos[i].getDescription());
                    continue;
                }
                System.out.println("" + i + "  " + aInfos[i].getName());
                continue;
            }
            catch (MidiUnavailableException e) {
                // empty catch block
            }
        }
        if (aInfos.length == 0) {
            controllers.add("No devices available");
        }
        return controllers;
    }

    public static MidiDevice.Info getMidiDeviceInfo(int index) {
        MidiDevice.Info[] aInfos = MidiSystem.getMidiDeviceInfo();
        if (index < 0 || index >= aInfos.length) {
            return null;
        }
        return aInfos[index];
    }

    public void addMidiListener(MidiListener cl) {
        if (this.midiListener.contains(cl)) {
            return;
        }
        this.midiListener.add(cl);
    }

    protected void addMidiEvent(int which, int value) {
        for (int x = 0; x < this.midiListener.size(); ++x) {
            MidiListener l = this.midiListener.get(x);
            l.signalReceived(which, value);
        }
    }

    public void removeMidiListener(MidiListener ml) {
        this.midiListener.remove(ml);
    }

    public void useControllerIN(int selectedIndex) {
        try {
            MidiDevice inputDevice = null;
            MidiDevice.Info info = MidiController.getMidiDeviceInfo(selectedIndex);
            inputDevice = MidiSystem.getMidiDevice(info);
            inputDevice.open();
            this.r = new MidiReceiver(System.out, this);
            this.t = inputDevice.getTransmitter();
            this.t.setReceiver(this.r);
        }
        catch (MidiUnavailableException e) {
            System.out.println("midi unavailable exception...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void useControllerOUT(int selectedIndex) {
        try {
            MidiDevice inputDevice2 = null;
            MidiDevice.Info info2 = MidiController.getMidiDeviceInfo(3);
            inputDevice2 = MidiSystem.getMidiDevice(info2);
            inputDevice2.open();
            this.recout = inputDevice2.getReceiver();
        }
        catch (MidiUnavailableException e) {
            new exceptionDialog(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            new exceptionDialog(e);
        }
    }

    public void clearBindings() {
        this.bindings.clear();
    }
}

