/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import sumo.opengl.OpenGLSettings;
import sumo.project.Project;
import sumo.resource.types.FBOResource;
import sumo.resource.types.Texture;
import sumo.resource.types.textureFile;

public class FBO {
    public int frameBuffer = -1;
    int depthbuffer = -1;
    boolean initialized = false;
    public Texture texture;
    public Texture textureDepth;
    int width = 0;
    int height = 0;
    public int buffer;
    private int type = 1;
    public static final int TYPE_RENDER_COLOR_BUFFER = 1;
    public static final int TYPE_RENDER_DEPTH_BUFFER = 2;
    public static final int TYPE_RENDER_COLOR_AND_DEPTH_BUFFER = 3;
    public static final String FBO_FRAMEBUFFER1_FILENAME = "framebuffer 1";
    public static final String FBO_FRAMEBUFFER2_FILENAME = "framebuffer 2";
    public static final String FBO_FRAMEBUFFER3_FILENAME = "framebuffer 3 color";
    public static final String FBO_DEPTH_BUFFER_FILENAME = "framebuffer 3 depth";
    public static FBO[] FBOs = new FBO[3];
    private static boolean inited = false;
    private static boolean initedTextures = false;

    public textureFile getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public FBO(Texture texture, Texture tdepth, int type) {
        this.type = type;
        this.texture = texture;
        System.out.println("creating fbo...");
        if (type == 3 || type == 2) {
            this.textureDepth = tdepth;
            System.out.println("depth: " + this.textureDepth.getID());
        }
        IntBuffer ib_fb = BufferUtils.createIntBuffer((int)1);
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)ib_fb);
        if (type == 3 || type == 2) {
            IntBuffer ib_db = BufferUtils.createIntBuffer((int)1);
            EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)ib_db);
            this.depthbuffer = ib_db.get(0);
        }
        this.frameBuffer = ib_fb.get(0);
        this.bind();
        this.checkFrameBufferStatus();
        FBO.unbindAll();
    }

    public static void initFrameBufferTextures(OpenGLSettings settings) {
        if (!initedTextures) {
            initedTextures = true;
            System.out.println("init framebuffer textures... " + (int)settings.getFBWidth() + " x " + (int)settings.getFBHeight());
            FBOResource FBOResource1 = new FBOResource(FBO_FRAMEBUFFER1_FILENAME, (int)settings.getFBWidth(), (int)settings.getFBHeight(), true, false);
            FBOResource FBOResource2 = new FBOResource(FBO_FRAMEBUFFER2_FILENAME, (int)settings.getFBWidth(), (int)settings.getFBHeight(), true, false);
            FBOResource FBOResource3 = new FBOResource(FBO_FRAMEBUFFER3_FILENAME, (int)settings.getFBWidth(), (int)settings.getFBHeight(), true, false);
            FBOResource FBOResource3_depth = new FBOResource(FBO_DEPTH_BUFFER_FILENAME, (int)settings.getFBWidth(), (int)settings.getFBHeight(), true, true);
            Project.getProject().getResourceManager().add(FBOResource1);
            Project.getProject().getResourceManager().add(FBOResource2);
            Project.getProject().getResourceManager().add(FBOResource3);
            Project.getProject().getResourceManager().add(FBOResource3_depth);
        }
    }

    public static void initFrameBuffers() {
        if (!inited) {
            System.out.println("init framebuffers...");
            inited = true;
            FBO.FBOs[0] = new FBO((FBOResource)Project.getProject().getResourceManager().getResourceByFileName(FBO_FRAMEBUFFER1_FILENAME), null, 1);
            FBO.FBOs[1] = new FBO((FBOResource)Project.getProject().getResourceManager().getResourceByFileName(FBO_FRAMEBUFFER2_FILENAME), null, 1);
            FBO.FBOs[2] = new FBO((FBOResource)Project.getProject().getResourceManager().getResourceByFileName(FBO_FRAMEBUFFER3_FILENAME), (FBOResource)Project.getProject().getResourceManager().getResourceByFileName(FBO_DEPTH_BUFFER_FILENAME), 3);
        }
    }

    void checkFrameBufferStatus() {
        int er = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        try {
            switch (er) {
                case 36053: {
                    System.out.println("framebuffer complete...");
                    break;
                }
                case 36054: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
                }
                case 36055: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
                }
                case 36057: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
                }
                case 36059: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
                }
                case 36058: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
                }
                case 36060: {
                    throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
                }
                default: {
                    throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + er);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void bind() {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthbuffer);
        if (!this.initialized) {
            this.init();
        }
        if (this.type == 2) {
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
        } else {
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            GL11.glClear((int)16384);
        }
    }

    private void init() {
        this.initialized = true;
        if (this.texture != null) {
            this.width = this.texture.width;
            this.height = this.texture.height;
        } else {
            this.width = this.textureDepth.width;
            this.height = this.textureDepth.height;
        }
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)this.width, (int)this.height);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthbuffer);
        if (this.type == 2 || this.type == 3) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)this.textureDepth.texturetype, (int)this.textureDepth.getID(), (int)0);
        }
        if (this.type == 3 || this.type == 1) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)34037, (int)this.texture.getID(), (int)0);
        }
    }

    protected static void unbindAll() {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

