/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.evokebeam;

import java.util.ArrayList;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import sumo.keyframing.KeyframedFloat;
import sumo.plugins.evokebeam.data.Result;
import sumo.plugins.evokebeam.data.Text;
import sumo.resource.types.textureFile;
import sumo.tools.freeTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoResults {
    int allPoints = 0;
    public int currentStep = 0;
    Text titleText;
    private static final int STEP_0_NOBARS = 0;
    private static final int STEP_1_ANIMATEBARS = 1;
    private static final int STEP_2_SHOWTHIRDPLACE = 2;
    private static final int STEP_3_SHOWSECONDPLACE = 3;
    private static final int STEP_4_SHOWFIRSTPLACE = 4;
    private static final int STEP_5_SHOWALL = 5;
    private ArrayList<Result> results = new ArrayList();
    private textureFile barTexture;
    private textureFile placeBackgroundTexture1;
    private textureFile placeBackgroundTexture2;
    private textureFile placeBackgroundTexture3;
    private int barMaxWidth = 1229;
    int tempPoints = 0;
    int place3points = 0;
    int place2points = 0;
    int place1points = 0;
    freeTimer mytime;
    public KeyframedFloat perc = new KeyframedFloat();

    public CompoResults() {
        this.mytime = new freeTimer();
        this.mytime.starttime = Sys.getTime();
    }

    public void addResult(Result r) {
        this.allPoints += r.getPoints();
        if (r.getPoints() > this.tempPoints) {
            this.tempPoints = r.getPoints();
        }
        this.results.add(r);
    }

    public void draw() {
        int i;
        int offsetY = 90;
        for (i = 0; i < this.results.size(); ++i) {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            CompoResults.drawBarHaxx0r(this.barTexture, 10.0f, i * 50 + offsetY, (int)((float)this.barMaxWidth * 0.7523f), 47.0f, this.barMaxWidth);
        }
        if (this.currentStep == 1 || this.currentStep == 2 || this.currentStep == 3 || this.currentStep == 4 || this.currentStep >= 5) {
            for (i = 0; i < this.results.size(); ++i) {
                Result r = this.results.get(i);
                float barWidth = (int)((float)this.barMaxWidth / (float)this.tempPoints * this.perc.getValue(this.mytime.getTime()));
                float barCWidth = (int)((float)this.barMaxWidth / (float)this.tempPoints * (float)r.getPoints());
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                CompoResults.drawBar(this.barTexture, 10.0f, i * 50 + offsetY, Math.min(barWidth, barCWidth), 47.0f, this.barMaxWidth);
                int circlex = -10;
                int circleOffsetY = -20;
                int circleSize = 90;
                if (this.currentStep >= 2 && r.getPlace() == 3) {
                    CompoResults.drawRect(this.placeBackgroundTexture3, circlex, i * 50 + offsetY + circleOffsetY, circleSize, circleSize);
                }
                if (this.currentStep >= 3 && r.getPlace() == 2) {
                    CompoResults.drawRect(this.placeBackgroundTexture2, circlex, i * 50 + offsetY + circleOffsetY, circleSize, circleSize);
                }
                if (this.currentStep >= 4 && r.getPlace() == 1) {
                    CompoResults.drawRect(this.placeBackgroundTexture1, circlex, i * 50 + offsetY + circleOffsetY, circleSize, circleSize);
                }
                int limit_place = 1000;
                boolean drawPlace = false;
                if (this.currentStep == 2 && r.getPlace() == 3) {
                    drawPlace = true;
                } else if (this.currentStep == 3 && (r.getPlace() == 2 || r.getPlace() == 3)) {
                    drawPlace = true;
                } else if (this.currentStep == 4 && (r.getPlace() == 2 || r.getPlace() == 1 || r.getPlace() == 3)) {
                    drawPlace = true;
                } else if (this.currentStep >= 5) {
                    drawPlace = true;
                }
                if (!drawPlace) continue;
                r.titleText.setX(72);
                r.titleText.setY(i * 50 + 50 + 37);
                r.titleText.draw(1.0f);
            }
        }
    }

    public ArrayList<Result> getResults() {
        return this.results;
    }

    public static void drawBarHaxx0r(textureFile tex, float x, float y, float width, float height, int maxWidth) {
        float cx = x;
        float cy = y;
        tex.enable();
        tex.bind();
        float tw = width / (float)maxWidth;
        GL11.glBegin((int)7);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)tex.height);
        GL11.glVertex2f((float)cx, (float)cy);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)cx, (float)(cy + height));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glTexCoord2f((float)(tw * (float)tex.width), (float)0.0f);
        GL11.glVertex2f((float)(cx + 1229.0f), (float)(cy + height));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glTexCoord2f((float)(tw * (float)tex.width), (float)tex.height);
        GL11.glVertex2f((float)(cx + 1229.0f), (float)cy);
        GL11.glEnd();
    }

    public static void drawBar(textureFile tex, float x, float y, float width, float height, int maxWidth) {
        float cx = x;
        float cy = y;
        tex.enable();
        tex.bind();
        float tw = width / (float)maxWidth;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)tex.height);
        GL11.glVertex2f((float)cx, (float)cy);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)cx, (float)(cy + height));
        GL11.glTexCoord2f((float)(tw * (float)tex.width), (float)0.0f);
        GL11.glVertex2f((float)(cx + width), (float)(cy + height));
        GL11.glTexCoord2f((float)(tw * (float)tex.width), (float)tex.height);
        GL11.glVertex2f((float)(cx + width), (float)cy);
        GL11.glEnd();
    }

    public static void drawRect(textureFile tex, float x, float y, float width, float height) {
        float cx = x;
        float cy = y;
        tex.enable();
        tex.bind();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)tex.height);
        GL11.glVertex2f((float)cx, (float)cy);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)cx, (float)(cy + height));
        GL11.glTexCoord2f((float)tex.width, (float)0.0f);
        GL11.glVertex2f((float)(cx + width), (float)(cy + height));
        GL11.glTexCoord2f((float)tex.width, (float)tex.height);
        GL11.glVertex2f((float)(cx + width), (float)cy);
        GL11.glEnd();
    }

    public textureFile getBarTexture() {
        return this.barTexture;
    }

    public void setBarTexture(textureFile barTexture) {
        this.barTexture = barTexture;
    }

    public void setPlaceBackgroundTextures(textureFile tfcircle1, textureFile tfcircle2, textureFile tfcircle3) {
        this.placeBackgroundTexture1 = tfcircle1;
        this.placeBackgroundTexture2 = tfcircle2;
        this.placeBackgroundTexture3 = tfcircle3;
    }

    public void continueResults() {
        ++this.currentStep;
        if (this.currentStep == 1) {
            for (Result r : this.results) {
                if (r.getPlace() != 3) continue;
                this.place3points = r.getPoints();
            }
            if (this.place3points == 0) {
                for (Result r : this.results) {
                    if (r.getPlace() != 2) continue;
                    this.place3points = r.getPoints();
                }
            }
            if (this.place3points == 0) {
                for (Result r : this.results) {
                    if (r.getPlace() != 1) continue;
                    this.place3points = r.getPoints();
                }
            }
            this.perc.setDefaultInterpolationMode((short)0);
            this.perc.setKeyframingEnabled(true);
            this.perc.addKey(this.mytime.getTime(), Float.valueOf(0.0f));
            this.perc.addKey(this.mytime.getTime() + 5.0f, Float.valueOf(this.place3points));
        }
        if (this.currentStep == 2) {
            for (Result r : this.results) {
                if (r.getPlace() != 2) continue;
                this.place2points = r.getPoints();
            }
            if (this.place2points == 0) {
                for (Result r : this.results) {
                    if (r.getPlace() != 1) continue;
                    this.place2points = r.getPoints();
                }
            }
            this.perc.setDefaultInterpolationMode((short)0);
            this.perc.setKeyframingEnabled(true);
            this.perc.addKey(this.mytime.getTime(), Float.valueOf(this.place3points));
            this.perc.addKey(this.mytime.getTime() + 2.5f, Float.valueOf(this.place2points));
        }
        if (this.currentStep == 3) {
            for (Result r : this.results) {
                if (r.getPlace() != 1) continue;
                this.place1points = r.getPoints();
            }
            this.perc.addKey(this.mytime.getTime() + 2.5f, Float.valueOf(this.place1points));
            this.perc.addKey(this.mytime.getTime(), Float.valueOf(this.place2points));
        }
        if (this.currentStep == 4) {
            for (Result r : this.results) {
                if (r.getPlace() != 1) continue;
                this.place1points = r.getPoints();
            }
        }
    }

    public void setTitle(String title) {
        this.titleText = new Text();
        this.titleText.setX(20);
        this.titleText.setY(20);
        this.titleText.setMaxHeight(60);
        this.titleText.setMaxWidth(100);
        this.titleText.setText(title, 30, 30, 30, true);
    }
}

