/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.sceneStripes;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.resource.types.v3d;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.math.Vec3f;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.Object;

public class SceneStripes
extends Plugin {
    Scene s;
    public KeyframedResource scene;

    public void init() {
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SceneStripes.this.s = ((v3d)SceneStripes.this.scene.getResource()).getScene();
                SceneStripes.this.getAbstractLine().rebuildPluginPanel();
            }
        });
    }

    public void render() {
        ArrayList<Vec3f> points = new ArrayList<Vec3f>();
        if (this.s != null) {
            int y;
            int x;
            List<NodeIF> nodes = this.s.rootnode.getChilds(1);
            for (NodeIF node : nodes) {
                Object obj = (Object)node;
                Mesh m = obj.meshes.get(0);
                if (m == null || m.vertices == null) continue;
                for (int i = 0; i < m.vertices.length; ++i) {
                    if (obj.posAnim != null) {
                        points.add(new Vec3f(m.vertices[i].x + obj.posAnim.x.getValue(), m.vertices[i].y + obj.posAnim.y.getValue(), m.vertices[i].z + obj.posAnim.z.getValue()));
                        continue;
                    }
                    points.add(new Vec3f(m.vertices[i].x + obj.pos.x, m.vertices[i].y + obj.pos.y, m.vertices[i].z + obj.pos.z));
                }
            }
            Vec3f max = new Vec3f();
            Vec3f min = new Vec3f();
            for (Vec3f p : points) {
                p.glVertex();
                if (p.x > max.x) {
                    max.x = p.x;
                }
                if (p.y > max.y) {
                    max.y = p.y;
                }
                if (p.z > max.z) {
                    max.z = p.z;
                }
                if (p.x < min.x) {
                    min.x = p.x;
                }
                if (p.y < min.y) {
                    min.y = p.y;
                }
                if (!(p.z < min.z)) continue;
                min.z = p.z;
            }
            int width = 30;
            int height = 20;
            float widthx = max.x - min.x;
            float widthy = max.y - min.y;
            float widthz = max.z - min.z;
            float stepx = widthx / (float)width;
            float stepy = widthy / (float)height;
            float[] heightmap = new float[width * height];
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    heightmap[x + y * width] = widthz / 2.0f;
                    for (Vec3f p : points) {
                        if (!(p.x > (float)x * stepx) || !(p.x < (float)x * stepx + stepx) || !(p.y > (float)y * stepy) || !(p.y < (float)y * stepy + stepy)) continue;
                        heightmap[x + y * width] = p.z;
                    }
                }
            }
            GL11.glLoadIdentity();
            this.s.getCam().render(0.0f);
            for (x = 0; x < width; ++x) {
                GL11.glLineWidth((float)2.0f);
                GL11.glBegin((int)3);
                GL11.glLineWidth((float)2.0f);
                for (y = 0; y < height; ++y) {
                    GL11.glVertex3f((float)((float)x * stepx), (float)((float)y * stepy), (float)(heightmap[x + y * width] * 1.1f));
                }
                GL11.glEnd();
            }
        }
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

