/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.sceneparticles;

import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.plugins.sceneparticles.Particle;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.v3d.Camera;
import sumo.v3d.Scene;
import sumo.v3d.math.Vec3f;
import sumoTween.Tweener;

public class SceneParticles
extends Plugin {
    public KeyframedResource image;
    public Tweener size;
    private float scale = 1.0f;
    private textureFile currenTexture = null;
    public KeyframedBoolean drawLines;
    public Tweener type;
    Scene s;
    public KeyframedResource scene;
    Particle[] particles;
    Vec3f maxpos = new Vec3f(29000.0f, 29000.0f, 29000.0f);

    public void init() {
        this.type.setTitleValues(new String[]{"triangle", "cube", "billboard"});
        this.initParticles();
        this.image.setResource(new textureFile());
        this.image.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SceneParticles.this.currenTexture = (textureFile)SceneParticles.this.image.getResource();
            }
        });
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SceneParticles.this.s = ((v3d)SceneParticles.this.scene.getResource()).getScene();
                SceneParticles.this.getAbstractLine().rebuildPluginPanel();
            }
        });
    }

    private void initParticles() {
        this.particles = new Particle[200];
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new Particle(this.maxpos);
        }
    }

    public void render() {
        GL11.glLoadIdentity();
        if (this.s == null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-6.0f);
        } else {
            Camera c = (Camera)this.s.getCam();
            c.gluLookAt(this.s.lasttime);
        }
        float siz = this.size.getValue() * 100.0f;
        if (this.currenTexture != null) {
            SceneParticles sceneParticles = this;
            sceneParticles.currenTexture.enable();
            this.currenTexture.bind();
        } else {
            textureFile.disable();
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        float time = Project.getProject().getTime();
        Particle.drawLines = this.drawLines.getValue();
        if (this.type.getIntValue() == 0) {
            for (int i = 0; i < this.particles.length; ++i) {
                this.particles[i].draw(time);
            }
        } else if (this.type.getIntValue() == 1) {
            for (int i = 0; i < this.particles.length; ++i) {
                this.particles[i].drawPre(time);
                this.drawCube();
                this.particles[i].drawpost();
            }
        } else if (this.type.getIntValue() == 2 && this.currenTexture != null) {
            this.currenTexture.bind();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
            for (int i = 0; i < this.particles.length; ++i) {
                this.particles[i].drawPre(time);
                this.particles[i].drawBillBoard(siz, this.currenTexture.width);
                this.particles[i].drawpost();
            }
            GL11.glDepthMask((boolean)true);
        }
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    private void drawCube() {
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)(1.0f * (float)this.currenTexture.height));
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.currenTexture.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glEnd();
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

