/*
 * Decompiled with CFR 0.152.
 */
package sumo.timing;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.fmod3.FSound;
import org.lwjgl.fmod3.FSoundDSPUnit;
import org.lwjgl.fmod3.FSoundStream;
import org.w3c.dom.Element;
import sumo.gui.detail.keyframeable.FloatDetail;
import sumo.project.Project;
import sumo.resource.types.FMODFile;
import sumoTween.timer.TimerIF;

public class timerFMOD
implements TimerIF {
    FMODFile mp3 = null;
    boolean isPlaying = false;
    public static ArrayList<Float> levels = new ArrayList();
    long starttime = 0L;
    public static FloatBuffer currentLevels = BufferUtils.createFloatBuffer((int)2);
    public static FloatBuffer spectrum;
    boolean fftbool = false;
    long lastFFTTime = 0L;
    long lastFFTHIT = 0L;
    public static float smoothLevel;
    public static float fftvalue;
    public static float fftvalue2;
    public static boolean repaintSpectrum;
    public static final int FFT_MODE_AVERAGE = 0;
    public static final int FFT_MODE_MAX = 1;

    public String getTitle() {
        return "mp3 timing (" + this.mp3.getFilename() + ")";
    }

    public float getTime() {
        if (this.mp3.stream != null) {
            FSound.FSOUND_GetCurrentLevels((int)0, (FloatBuffer)currentLevels);
            this.updateLevels();
            if (this.isPlaying) {
                if (Sys.getTime() - this.lastFFTTime >= 30L && spectrum != null) {
                    if (repaintSpectrum) {
                        FloatDetail.spectrumPanel.repaint();
                    }
                    this.lastFFTTime = Sys.getTime();
                    fftvalue2 -= 0.1f;
                    if (spectrum.get(150) > 0.07f && Sys.getTime() - this.lastFFTHIT > 90L) {
                        fftvalue2 = 0.5f;
                    }
                    if (fftvalue2 < 0.0f) {
                        fftvalue2 = 0.0f;
                    }
                    if (spectrum.get(3) > 0.5f && Sys.getTime() - this.lastFFTHIT > 90L) {
                        this.lastFFTHIT = Sys.getTime();
                        boolean bl = this.fftbool = !this.fftbool;
                        fftvalue = this.fftbool ? 0.53f : 0.83f;
                    } else {
                        fftvalue -= 0.004f;
                    }
                }
                spectrum = FSound.FSOUND_DSP_GetSpectrum();
            }
        }
        if (this.mp3.stream == null) {
            return 0.0f;
        }
        this.updateLevels();
        if (this.isPlaying) {
            return (float)(Sys.getTime() - this.starttime) / 1000.0f;
        }
        return (float)FSound.FSOUND_Stream_GetTime((FSoundStream)this.mp3.stream) / 1000.0f;
    }

    private void updateLevels() {
        levels.add(Float.valueOf(currentLevels.get(0)));
        if (levels.size() > 10) {
            levels.remove(0);
        }
        for (int i = 0; i < levels.size(); ++i) {
            smoothLevel += levels.get(i).floatValue();
        }
        smoothLevel /= (float)levels.size();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void pause() {
        FSound.FSOUND_Stream_Stop((FSoundStream)this.mp3.stream);
        this.isPlaying = false;
        System.out.println("pause");
    }

    public void play() {
        FSound.FSOUND_Stream_SetTime((FSoundStream)this.mp3.stream, (int)((int)(Project.getProject().getTime() * 1000.0f)));
        this.starttime = Sys.getTime() - (long)(Project.getProject().getTime() * 1000.0f);
        FSound.FSOUND_DSP_SetActive((FSoundDSPUnit)FSound.FSOUND_DSP_GetFFTUnit(), (boolean)true);
        FSound.FSOUND_Stream_Play((int)0, (FSoundStream)this.mp3.stream);
        FSound.FSOUND_Stream_SetTime((FSoundStream)this.mp3.stream, (int)((int)(Project.getProject().getTime() * 1000.0f)));
        this.isPlaying = true;
        System.out.println("play");
    }

    public void setPlayRange(float start, float end) {
    }

    public void setTime(float f) {
        FSound.FSOUND_Stream_SetTime((FSoundStream)this.mp3.stream, (int)((int)(f * 1000.0f)));
        this.starttime = Sys.getTime() - (long)(f * 1000.0f);
    }

    public void setMP3(FMODFile f) {
        this.mp3 = f;
    }

    public void saveXML(Element root) {
        Element eltex = root.getOwnerDocument().createElement("timer");
        eltex.setAttribute("filename", this.mp3.filename);
        eltex.setAttribute("path", this.mp3.path);
        root.appendChild(eltex);
    }

    public static float getFFT(int mode, int start, int end, float fftMinus, float fftmulti) {
        if (spectrum != null && end > start && start > 0 && end > 0) {
            float temp = 0.0f;
            int size = end - start;
            float r = 0.0f;
            if (mode == 0) {
                for (int i = start; i < end; ++i) {
                    r += spectrum.get(i);
                }
                r /= (float)size;
            } else if (mode == 1) {
                for (int i = start; i < end; ++i) {
                    temp = spectrum.get(i);
                    if (!(temp > r)) continue;
                    r = temp;
                }
            }
            r -= fftMinus;
            if (r < 0.0f) {
                r = 0.0f;
            }
            if (r > 1.0f) {
                r = 1.0f;
            }
            return r *= 1.0f / fftmulti;
        }
        return 0.0f;
    }

    static {
        smoothLevel = 0.0f;
        fftvalue = 0.0f;
        fftvalue2 = 0.0f;
    }
}

