/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Vec3fkeyframed;

public class Light
extends Node
implements NodeIF {
    public FloatBuffer colorDiffuseFB = BufferUtils.createFloatBuffer((int)4);
    public FloatBuffer colorAmbientFB = BufferUtils.createFloatBuffer((int)4);
    public FloatBuffer colorSpecularFB = BufferUtils.createFloatBuffer((int)4);
    public Vec3fkeyframed posAnim = null;
    public FloatBuffer pos = BufferUtils.createFloatBuffer((int)4);

    public void setPos(float x, float y, float z) {
        float[] fff = new float[]{x, y, z};
        this.pos.put(fff).rewind();
    }

    public void setDiffuse(float r, float g, float b) {
        this.colorDiffuseFB.put(new float[]{r, g, b, 1.0f}).rewind();
    }

    public Light() {
        this.type = 2;
        this.setOrder(10);
        this.colorAmbientFB.put(new float[]{0.2f, 0.2f, 0.2f, 1.0f}).rewind();
        this.colorSpecularFB.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f}).rewind();
        this.colorDiffuseFB.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f}).rewind();
    }

    public void render(float time) {
        if (this.posAnim != null) {
            this.setPos(this.posAnim.x.getValue(time), this.posAnim.y.getValue(time), this.posAnim.z.getValue(time));
        }
        GL11.glLight((int)16385, (int)4611, (FloatBuffer)this.pos);
        GL11.glEnable((int)2896);
        GL11.glLightModel((int)2899, (FloatBuffer)this.colorAmbientFB);
        GL11.glEnable((int)16385);
        GL11.glLight((int)16385, (int)4608, (FloatBuffer)this.colorAmbientFB);
        GL11.glLight((int)16385, (int)4609, (FloatBuffer)this.colorDiffuseFB);
        GL11.glLight((int)16385, (int)4610, (FloatBuffer)this.colorSpecularFB);
    }
}

