/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.glu.GLU;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.Shadow;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene {
    public Vec3f backgroundcolor = new Vec3f();
    public Node rootnode = new Node();
    public ArrayList<Material> materials = new ArrayList();
    public boolean mousecontrolEnabled = false;
    public float animLength = 1.0f;
    public float animStart = 0.0f;
    public float currentTime = 0.0f;
    private int currentCam = -1;
    public boolean shadowed = true;
    public Shadow shadow = null;
    public float lasttime = 0.0f;
    public boolean loop = false;
    float scenerotx = 0.0f;
    float sceneroty = 0.0f;
    float scenerotz = 0.0f;
    float move_x = 0.0f;
    float move_y = 0.0f;
    public float animOffset;

    public void render(float time) {
        if (this.loop) {
            time = (time - this.animStart) % this.animLength;
        }
        this.lasttime = time;
        if (this.shadowed) {
            if (this.shadow == null) {
                this.shadow = new Shadow(this);
            }
            this.shadow.renderShadow(this, this.rootnode, time, this.getCam(this.getCamNum()));
        } else {
            this.rootnode.render(time);
        }
    }

    public Camera getCam(int value) {
        if (value < 0) {
            return null;
        }
        List<NodeIF> cams = this.rootnode.getChilds(3);
        if (value > cams.size() - 1) {
            return null;
        }
        return (Camera)cams.get(value);
    }

    public void setCam(int which) {
        if (which < 0) {
            return;
        }
        List<NodeIF> cams = this.rootnode.getChilds(3);
        if (which > cams.size() - 1) {
            return;
        }
        this.rootnode.disableChildsByType(3);
        cams.get(which).setEnabled(true);
        this.currentCam = which;
    }

    public NodeIF getCam() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        return cams.get(this.currentCam);
    }

    public int getCamNum() {
        return this.currentCam;
    }

    public int getNumCameras() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        return cams.size();
    }

    public int getNumMeshes() {
        List<NodeIF> cams = this.rootnode.getChilds(1);
        return cams.size();
    }

    public List<NodeIF> getMeshes() {
        return this.rootnode.getChilds(1);
    }

    public List<NodeIF> getMeshesByNameContains(String c) {
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        ArrayList<NodeIF> ret = new ArrayList<NodeIF>();
        for (NodeIF n : nodes) {
            if (!n.getName().contains(c)) continue;
            ret.add(n);
        }
        return ret;
    }

    public int getNumLights() {
        List<NodeIF> cams = this.rootnode.getChilds(2);
        return cams.size();
    }

    public int getNumNodes() {
        return this.rootnode.childs.size();
    }

    public void mouseControl() {
        Keyboard.poll();
        this.rootnode.disableChildsByType(3);
        if (Keyboard.isKeyDown((int)205)) {
            this.scenerotz += 0.1f;
        }
        if (Keyboard.isKeyDown((int)203)) {
            this.scenerotz -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)200)) {
            this.move_x += 50.9f;
        }
        if (Keyboard.isKeyDown((int)208)) {
            this.move_x -= 50.9f;
        }
        if (Mouse.isButtonDown((int)0)) {
            this.scenerotx += (float)Mouse.getDY() * -0.001f;
            this.sceneroty += (float)Mouse.getDX() * -0.001f;
        }
        float theta = this.scenerotx;
        float phi = this.sceneroty;
        GLU.gluLookAt((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)(Math.cos(theta) * Math.sin(phi))), (float)((float)Math.cos(phi)), (float)((float)(Math.sin(theta) * Math.sin(phi))), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public String[] getCameraTitles() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        String[] s = new String[cams.size()];
        for (int i = 0; i < cams.size(); ++i) {
            s[i] = cams.get(i).getName();
        }
        return s;
    }

    public ArrayList<Material> getMaterials() {
        return this.materials;
    }

    public Light getLight() {
        Light l = null;
        List<NodeIF> lights = this.rootnode.getChilds(2);
        if (lights.size() > 0) {
            l = (Light)lights.get(0);
        }
        return l;
    }

    public Material getMaterialByTitle(String t) {
        for (Material m : this.materials) {
            System.out.println(m.title);
            if (!m.title.equals(t)) continue;
            return m;
        }
        return null;
    }

    public NodeIF getMeshObject(String title) {
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        if (nodes.size() == 0) {
            return null;
        }
        for (NodeIF n : nodes) {
            if (!n.getName().equals(title)) continue;
            return n;
        }
        return null;
    }
}

