/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import sumo.opengl.FBO;
import sumo.opengl.FBOManager;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.Node;
import sumo.v3d.Scene;
import sumo.v3d.material.Material;

public class Shadow {
    static FloatBuffer matrixModelView;
    static FloatBuffer matrixProjection;
    static FloatBuffer matrixCameraInverse;
    static FBO shadowfFBO;
    public static Texture shadowTexture;
    public static int SHADOW_WIDTH;
    public static int SHADOW_HEIGHT;
    public float polyOffsetUnits = 2.0f;
    public float polyOffsetFactor = 1.0f;
    float[] mBias = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
    FloatBuffer fbBias = null;

    public Shadow(Scene scene) {
        if (shadowTexture == null) {
            shadowTexture = new Texture("", SHADOW_WIDTH, SHADOW_HEIGHT, false, true);
            shadowfFBO = new FBO(null, shadowTexture, 2);
        }
        ArrayList<Material> mats = scene.getMaterials();
        for (Material material : mats) {
            material.settings.shadowMap = shadowTexture;
        }
    }

    public void renderShadow(Scene scene, Node rootnode, float time, Camera cam) {
        FBOManager.bind(shadowfFBO);
        this.storeLightMatrices(scene);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)SHADOW_WIDTH, (int)SHADOW_HEIGHT);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GLU.gluPerspective((float)90.0f, (float)1.0f, (float)-1000.0f, (float)99999.0f);
        GL11.glLoadMatrix((FloatBuffer)matrixProjection);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)matrixModelView);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glPolygonOffset((float)this.polyOffsetFactor, (float)this.polyOffsetUnits);
        GL11.glEnable((int)32823);
        scene.getCam().setEnabled(false);
        cam.setEnabled(false);
        Material.enableMaterials = false;
        rootnode.render(time);
        Material.enableMaterials = true;
        scene.getCam().setEnabled(true);
        FBOManager.unbind();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)32823);
        if (FBOManager.isFBOBound()) {
            GL11.glViewport((int)0, (int)0, (int)FBOManager.getCurrentFBO().getWidth(), (int)FBOManager.getCurrentFBO().getHeight());
        } else {
            GL11.glViewport((int)0, (int)0, (int)Project.getProject().getOpenGLSsettings().getWidth(), (int)Project.getProject().getOpenGLSsettings().getHeight());
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glClear((int)256);
        GL11.glLoadIdentity();
        cam.gluLookAt(time);
        matrixCameraInverse = cam.getInverseMatrix(time);
        this.applyShadowMap(rootnode, time);
    }

    public void storeLightMatrices(Scene scene) {
        if (matrixModelView == null) {
            matrixModelView = BufferUtils.createFloatBuffer((int)16);
            matrixModelView.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
            matrixProjection = BufferUtils.createFloatBuffer((int)16);
            matrixProjection.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Light l = scene.getLight();
        GLU.gluLookAt((float)l.pos.get(0), (float)l.pos.get(1), (float)l.pos.get(2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixModelView);
        GL11.glPopMatrix();
        GL11.glLoadIdentity();
        Camera cam = scene.getCam(scene.getCamNum());
        GLU.gluPerspective((float)cam.fov, (float)1.0f, (float)cam.znear, (float)cam.zfar);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixProjection);
        GL11.glPopMatrix();
    }

    void applyShadowMap(Node rootnode, float time) {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)shadowTexture.getID());
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34893, (int)515);
        if (this.fbBias == null) {
            this.fbBias = BufferUtils.createFloatBuffer((int)16);
            this.fbBias.put(this.mBias).rewind();
        }
        GL11.glMatrixMode((int)5890);
        GL11.glLoadMatrix((FloatBuffer)this.fbBias);
        GL11.glMultMatrix((FloatBuffer)matrixProjection);
        GL11.glMultMatrix((FloatBuffer)matrixModelView);
        GL11.glMultMatrix((FloatBuffer)matrixCameraInverse);
        GL11.glMatrixMode((int)5888);
        rootnode.render(time);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
    }

    static {
        shadowfFBO = null;
        shadowTexture = null;
        SHADOW_WIDTH = 1024;
        SHADOW_HEIGHT = 1024;
    }
}

