/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.material;

import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import sumo.shader.SumoShader;
import sumo.v3d.material.MaterialRendererIF;
import sumo.v3d.material.MaterialSettings;
import sumo.v3d.material.MaterialShaderLib;

public class MaterialRendererShader
implements MaterialRendererIF {
    public SumoShader shader;
    MaterialSettings settings;
    boolean shaderBuilt = false;

    public void reload() {
        this.shader = MaterialShaderLib.createShader(this.settings);
    }

    public void buildShader() {
        this.shader = MaterialShaderLib.createShader(this.settings);
        this.shaderBuilt = true;
        if (this.settings.mapDiffuse != null && this.settings.mapDiffuse.texture != null) {
            this.shader.setMultiTexture(0, this.settings.mapDiffuse.texture.getID(), "map_diffuse");
        }
    }

    public void setSettings(MaterialSettings m) {
        this.settings = m;
    }

    public void bind() {
        if (!this.shaderBuilt) {
            this.buildShader();
        }
        if (this.shader == null) {
            System.out.println("materialrenderershader null");
            return;
        }
        if (this.settings.opacity != 1.0f) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)this.settings.colorDiffuseFB.get(0), (float)this.settings.colorDiffuseFB.get(1), (float)this.settings.colorDiffuseFB.get(2), (float)this.settings.opacity);
            GL11.glDepthMask((boolean)false);
        } else {
            GL11.glColor3f((float)this.settings.colorDiffuseFB.get(0), (float)this.settings.colorDiffuseFB.get(1), (float)this.settings.colorDiffuseFB.get(2));
        }
        if (this.settings.selfillumination == 100.0f) {
            GL11.glDisable((int)2896);
        }
        GL11.glEnable((int)2903);
        GL11.glMaterial((int)1032, (int)4609, (FloatBuffer)this.settings.colorDiffuseFB);
        GL11.glMaterial((int)1032, (int)4608, (FloatBuffer)this.settings.colorAmbientFB);
        GL11.glMaterial((int)1032, (int)4610, (FloatBuffer)this.settings.colorSpecularFB);
        GL11.glMaterialf((int)1032, (int)5633, (float)128.0f);
        GL11.glEnable((int)3553);
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34893, (int)515);
        if (this.shader != null) {
            this.shader.bind();
        }
    }

    public void unbind() {
        if (this.shader == null) {
            return;
        }
        this.shader.unbind();
        if (this.settings.opacity != 1.0f) {
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        }
        if (this.settings.selfillumination == 100.0f) {
            GL11.glEnable((int)2896);
        }
    }
}

