/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.math;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import sumo.v3d.math.Vec3f;

public class Matrix4 {
    public FloatBuffer fb = null;
    static int[] convMatrix = new int[]{0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15};
    float[] m = new float[16];

    float get(int i) {
        return this.fb.get(convMatrix[i]);
    }

    void createbuffer(float[] mx) {
        this.m[0] = mx[0];
        this.m[4] = mx[1];
        this.m[8] = mx[2];
        this.m[12] = mx[3];
        this.m[1] = mx[4];
        this.m[5] = mx[5];
        this.m[9] = mx[6];
        this.m[13] = mx[7];
        this.m[2] = mx[8];
        this.m[6] = mx[9];
        this.m[10] = mx[10];
        this.m[14] = mx[11];
        this.m[3] = mx[12];
        this.m[7] = mx[13];
        this.m[11] = mx[14];
        this.m[15] = mx[15];
        this.fb.put(this.m).flip();
    }

    public Matrix4(float[] f) {
        this.fb = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.createbuffer(f);
    }

    public Matrix4() {
        this.fb = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.createbuffer(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    public Matrix4(FloatBuffer m) {
        this.fb = m;
    }

    public void set(int which, float value) {
        this.fb.put(convMatrix[which], value);
    }

    public void set(float[] f) {
        this.createbuffer(f);
    }

    void set(float m0, float m1, float m2, float m3, float m4, float m5, float m6, float m7, float m8, float m9, float m10, float m11, float m12, float m13, float m14, float m15) {
        this.m[0] = m0;
        this.m[4] = m1;
        this.m[8] = m2;
        this.m[12] = m3;
        this.m[1] = m4;
        this.m[5] = m5;
        this.m[9] = m6;
        this.m[13] = m7;
        this.m[2] = m8;
        this.m[6] = m9;
        this.m[10] = m10;
        this.m[14] = m11;
        this.m[3] = m12;
        this.m[7] = m13;
        this.m[11] = m14;
        this.m[15] = m15;
        this.fb.put(this.m).flip();
    }

    public void glMulMatrix() {
        GL11.glMultMatrix((FloatBuffer)this.fb);
    }

    public void glTranslate() {
        GL11.glTranslatef((float)this.get(3), (float)this.get(7), (float)this.get(11));
    }

    public void setTranslation(Vec3f t) {
        this.fb.put(convMatrix[3], t.x);
        this.fb.put(convMatrix[7], t.y);
        this.fb.put(convMatrix[11], t.z);
    }

    public Vec3f getTranslation() {
        Vec3f tempTrans = new Vec3f();
        tempTrans.set(new float[]{this.get(3), this.get(7), this.get(11)});
        return tempTrans;
    }

    public void glLoadMatrix() {
        GL11.glLoadMatrix((FloatBuffer)this.fb);
    }

    public float[] getAsArray() {
        return new float[]{this.get(0), this.get(1), this.get(2), this.get(3), this.get(4), this.get(5), this.get(6), this.get(7), this.get(8), this.get(9), this.get(10), this.get(11), this.get(12), this.get(13), this.get(14), this.get(15)};
    }
}

