/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import java.util.ArrayList;
import java.util.List;
import sumo.keyframing.KeyframedFloat;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec1i;
import sumo.v3d.math.Vec2f;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3s;
import sumo.v3d.math.Vec4s;
import sumo.v3d.mesh.AnimVerts;
import sumo.v3d.mesh.RendererIF;
import sumo.v3d.mesh.RendererIntermediate;
import sumo.v3d.mesh.RendererVBO;

public class Mesh {
    public Vec4s[] faces;
    public Vec3f[] vertices;
    private String name = "no name";
    public List<AnimVerts> animVertices = new ArrayList<AnimVerts>();
    public List<AnimVerts> animNormals = new ArrayList<AnimVerts>();
    public Vec3s[] textureFaces;
    public Vec2f[] textureCoords;
    public Vec3f[] normals;
    public ArrayList<Material> materials;
    public ArrayList<Vec1i> materialIDs;
    public static boolean renderVBO = true;
    public RendererIF rendererIntermediate = new RendererIntermediate();
    public RendererIF rendererVBO = new RendererVBO();
    public KeyframedFloat animStep = new KeyframedFloat();

    public Mesh() {
        this.animStep.setDefaultInterpolationMode((short)0);
        this.animStep.setKeyframingEnabled(true);
    }

    public void render(float time) {
        if (this.materials == null) {
            System.out.println("mesh materials NULL!!!" + this.getName());
            return;
        }
        if (this.animVertices.size() > 0 && !this.updateVertexAnim(time)) {
            return;
        }
        if (renderVBO) {
            this.rendererVBO.render(time, this);
        } else {
            if (this.rendererIntermediate == null) {
                this.rendererIntermediate = new RendererIntermediate();
            }
            this.rendererIntermediate.render(time, this);
        }
    }

    public void setTextureFaces(short[] v) {
        this.textureFaces = new Vec3s[v.length / 3];
        for (int i = 0; i < v.length; i += 3) {
            this.textureFaces[i / 3] = new Vec3s(v[i + 0], v[i + 1], v[i + 2]);
        }
    }

    public void setTextureCoords(float[] f) {
        this.textureCoords = new Vec2f[f.length / 2];
        for (int i = 0; i < f.length; i += 2) {
            Vec2f v;
            this.textureCoords[i / 2] = v = new Vec2f(f[i + 0], f[i + 1]);
        }
    }

    public void setVertices(float[] f) {
        this.vertices = new Vec3f[f.length / 3];
        int count = 0;
        for (int i = 0; i < f.length; i += 3) {
            this.vertices[count] = new Vec3f(f[i + 0], f[i + 1], f[i + 2]);
            ++count;
        }
    }

    public void setNormals(float[] f) {
        this.normals = new Vec3f[f.length / 3];
        int count = 0;
        for (int i = 0; i < f.length; i += 3) {
            this.normals[count] = new Vec3f(f[i + 0], f[i + 1], f[i + 2]);
            this.normals[count].normalize();
            ++count;
        }
    }

    public void setFaces(short[] v) {
        this.faces = new Vec4s[v.length / 4];
        int count = 0;
        for (int i = 0; i < v.length; i += 4) {
            this.faces[count] = new Vec4s(v[i + 0], v[i + 1], v[i + 2], v[i + 3]);
            ++count;
        }
    }

    boolean updateVertexAnim(float time) {
        int step = (int)this.animStep.getValue(time);
        int nextStep = (int)this.animStep.getNextValue();
        if (nextStep >= this.animStep.getKeys().length) {
            return true;
        }
        float perc = this.animStep.getPercent(time);
        AnimVerts step1 = this.animVertices.get(step);
        AnimVerts step2 = this.animVertices.get(nextStep);
        if (this.vertices.length < step1.vertices.length) {
            return false;
        }
        for (int i = 0; i < step1.vertices.length; ++i) {
            this.vertices[i].x = step1.vertices[i].x + (step2.vertices[i].x - step1.vertices[i].x) * perc;
            this.vertices[i].y = step1.vertices[i].y + (step2.vertices[i].y - step1.vertices[i].y) * perc;
            this.vertices[i].z = step1.vertices[i].z + (step2.vertices[i].z - step1.vertices[i].z) * perc;
        }
        AnimVerts nstep1 = this.animNormals.get(step);
        AnimVerts nstep2 = this.animNormals.get(nextStep);
        for (int i = 0; i < nstep1.vertices.length; ++i) {
            this.normals[i].x = nstep1.vertices[i].x + (nstep2.vertices[i].x - nstep1.vertices[i].x) * perc;
            this.normals[i].y = nstep1.vertices[i].y + (nstep2.vertices[i].y - nstep1.vertices[i].y) * perc;
            this.normals[i].z = nstep1.vertices[i].z + (nstep2.vertices[i].z - nstep1.vertices[i].z) * perc;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void calcNormals() {
        this.normals = new Vec3f[this.faces.length * 3];
        for (int i = 0; i < this.faces.length; ++i) {
            Vec3f norm = new Vec3f();
            norm.x = (this.vertices[this.faces[i].y].y - this.vertices[this.faces[i].x].y) * (this.vertices[this.faces[i].z].z - this.vertices[this.faces[i].x].z) - (this.vertices[this.faces[i].y].z - this.vertices[this.faces[i].x].z) * (this.vertices[this.faces[i].z].y - this.vertices[this.faces[i].x].y);
            norm.y = (this.vertices[this.faces[i].y].z - this.vertices[this.faces[i].x].z) * (this.vertices[this.faces[i].z].x - this.vertices[this.faces[i].x].x) - (this.vertices[this.faces[i].y].y - this.vertices[this.faces[i].x].y) * (this.vertices[this.faces[i].z].z - this.vertices[this.faces[i].x].z);
            norm.z = (this.vertices[this.faces[i].y].x - this.vertices[this.faces[i].x].x) * (this.vertices[this.faces[i].z].y - this.vertices[this.faces[i].x].y) - (this.vertices[this.faces[i].y].x - this.vertices[this.faces[i].x].x) * (this.vertices[this.faces[i].z].x - this.vertices[this.faces[i].x].x);
            System.out.println("Jo");
            if (this.normals[i * 3 + 0] == null) {
                this.normals[i * 3 + 0] = new Vec3f(norm.x, norm.y, norm.z);
            } else {
                this.normals[i * 3 + 0].average(norm);
            }
            if (this.normals[i * 3 + 1] == null) {
                this.normals[i * 3 + 1] = new Vec3f(norm.x, norm.y, norm.z);
            } else {
                this.normals[i * 3 + 1].average(norm);
            }
            if (this.normals[i * 3 + 2] == null) {
                this.normals[i * 3 + 2] = new Vec3f(norm.x, norm.y, norm.z);
                continue;
            }
            this.normals[i * 3 + 2].average(norm);
        }
    }
}

