/*
 * Decompiled with CFR 0.152.
 */
package sumoTween.demo.swing.keyview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.Back;
import sumoTween.easing.Bounce;
import sumoTween.easing.Circ;
import sumoTween.easing.Cubic;
import sumoTween.easing.EasingIF;
import sumoTween.easing.Expo;
import sumoTween.easing.Linear;
import sumoTween.easing.Quad;
import sumoTween.easing.Quart;
import sumoTween.easing.Quint;
import sumoTween.easing.Sine;
import sumoTween.events.KeyEvent;

public class DemoComponent
extends JComponent {
    Tweener testTween = new Tweener();
    Font font;
    int currentEasing = 0;
    int mousex = 0;
    int mousey = 0;
    float scale = 100.0f;
    Color bgcol = new Color(0xEEEEEE);
    EasingIF[] easings = new EasingIF[]{new Linear(), new Sine(), new Quad(), new Cubic(), new Expo(), new Back(), new Bounce(), new Quart(), new Quint(), new Circ()};

    public DemoComponent() {
        this.font = new Font("Arial", 0, 10);
        this.init();
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent arg0) {
                int i = 0;
                while ((float)i <= DemoComponent.this.testTween.getLastKey().getTime()) {
                    if ((float)DemoComponent.this.mousex < (float)(i + 1) * DemoComponent.this.scale && (float)DemoComponent.this.mousex > (float)i * DemoComponent.this.scale) {
                        DemoComponent.this.makeRandomEasing(i);
                    }
                    ++i;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                DemoComponent.this.mousex = e.getX();
                DemoComponent.this.mousey = e.getY();
            }

            public void mouseDragged(MouseEvent e) {
            }
        });
    }

    void makeRandomEasing(float time) {
        KeyFloat kf = this.testTween.getKey(time);
        kf.setEasingDirection((int)(Math.random() * 4.0) - 1);
        kf.setEasing(this.easings[(int)(Math.random() * (double)this.easings.length)]);
    }

    void init() {
        this.testTween.clear();
        this.testTween.set(0.0f, 2.0f, 1, new Cubic());
        this.testTween.set(1.0f, 200.0f, 2, new Cubic());
        this.testTween.set(2.0f, 100.0f, 2, new Back());
        this.testTween.set(3.0f, 300.0f, 2, new Cubic());
        this.testTween.set(4.0f, 0.0f, 1, new Bounce());
        this.testTween.set(5.0f, 130.0f, 2, new Linear());
        this.testTween.set(6.0f, 190.0f, 2, new Linear());
        this.testTween.set(7.0f, 100.0f, 2, new Linear(), new KeyEvent(){

            public void KeyEvent(KeyFloat keyFloat) {
                System.out.println("loop.....");
                DemoComponent.this.testTween.resetTimer();
            }
        });
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(new Color(0xFFFFFF));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        float incr = 0.02f;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while ((float)i <= this.testTween.getLastKey().getTime()) {
            if ((float)this.mousex < (float)(i + 1) * this.scale && (float)this.mousex > (float)i * this.scale) {
                g.setColor(this.bgcol);
                g.fillRect((int)((float)i * this.scale), 0, 100, 500);
            }
            g.setColor(Color.gray);
            g.drawString(this.testTween.getKey((float)i + 0.1f).toString(), (int)((float)i * this.scale) + 10, 20);
            g.drawLine((int)((float)i * this.scale), 0, (int)((float)i * this.scale), 500);
            ++i;
        }
        g.setColor(new Color(0x555555));
        g.fillRect((int)(this.testTween.getTime() * 100.0f) - 5, this.testTween.getIntValue() - 5, 10, 10);
        for (float f = 0.0f; f <= this.testTween.getLastKey().getTime() + 1.0f; f += incr) {
            int x = (int)(f * this.scale);
            int x2 = (int)((f + incr) * this.scale);
            g.setColor(Color.black);
            g.drawLine(x, this.testTween.getIntValue(f, false), x2, this.testTween.getIntValue(f + incr, false));
        }
    }
}

