/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lineTypeElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.AbstractLine;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.keyframeable.TweenerDetail;
import sumo.gui.lineTypeElements.ValueChangedListener;
import sumo.gui.lineTypeElements.ValueEvent;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.gui.timing.KeyFramePanelTweener;
import sumo.keyframing.KeyFramedIF;
import sumo.project.Project;
import sumoTween.Tweener;

public class guiTweener
extends JPanel
implements guiLineTypeIF {
    private KeyFramePanelTweener keyframepanel;
    private float startValue = 0.0f;
    private int mouseStartX = 0;
    private float oldvalue = 0.0f;
    private boolean mouseDragging = false;
    float value = 1.0f;
    private Vector<ValueChangedListener> valueChangedListeners = new Vector();
    private boolean mouseOver = false;
    Color fgColor = Settings.mainColor2;
    private boolean setDetail = true;
    private Tweener tweener;
    Color bgColor = Settings.lineBackground;
    public boolean drawBottomBorder = true;
    guiStopWatch watch = null;
    AbstractLine abstractLine = null;

    public guiTweener(Tweener f, int a) {
        this(f, true);
    }

    public guiTweener(Tweener f, boolean setDetail) {
        this.setDetail = setDetail;
        this.init();
        this.tweener = f;
    }

    public guiTweener() {
        this.init();
    }

    void init() {
        this.setBounds(new Rectangle(103, 16));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (guiTweener.this.setDetail) {
                    Project.getProject().setDetailPanel(new TweenerDetail(guiTweener.this.tweener, guiTweener.this.abstractLine));
                }
            }

            public void mouseEntered(MouseEvent e) {
                guiTweener.this.mouseOver = true;
                guiTweener.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                guiTweener.this.mouseOver = false;
                guiTweener.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                guiTweener.this.mouseOver = false;
                guiTweener.this.mouseDragging = false;
                guiTweener.this.oldvalue = 0.0f;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                guiTweener.this.mouseDragging = true;
                if (guiTweener.this.oldvalue == 0.0f) {
                    guiTweener.this.oldvalue = guiTweener.this.value;
                }
                guiTweener.this.value = guiTweener.this.oldvalue - ((float)guiTweener.this.mouseStartX - (float)e.getX()) / (float)guiTweener.this.getWidth();
                if (guiTweener.this.value > 1.0f) {
                    guiTweener.this.value = 1.0f;
                } else if (guiTweener.this.value < 0.0f) {
                    guiTweener.this.value = 0.0f;
                }
                guitest.setStatus(String.valueOf(guiTweener.this.value) + "");
                guiTweener.this.notifyValueChangedListeners();
                if (guiTweener.this.tweener != null) {
                    guiTweener.this.tweener.set(guiTweener.this.value);
                }
                guiTweener.this.mouseOver = true;
                guiTweener.this.repaint();
                if (guiTweener.this.keyframepanel != null) {
                    guiTweener.this.keyframepanel.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
                guiTweener.this.mouseStartX = e.getX();
            }
        });
    }

    public void setFnColor(Color c) {
        this.fgColor = c;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(2);
        }
        if (this.tweener != null) {
            this.value = this.tweener.getNormalizedValue();
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(this.bgColor);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.tweener.isKeyframed()) {
            gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gd.setColor(this.bgColor);
            gd.setColor(Settings.pluginTitleBackground);
            gd.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 3, 7, 7);
            int valuePixel = (int)((float)(this.getWidth() - 5) * this.value);
            int valueStartPixel = 2;
            if (this.startValue != 0.0f) {
                valueStartPixel = 2 + (int)((float)(this.getWidth() - 5) * this.startValue);
            }
            gd.setColor(this.fgColor);
            gd.fillRoundRect(valueStartPixel, 1, valuePixel -= valueStartPixel, this.getHeight() - 5, 5, 5);
            gd.setColor(Color.black);
            gd.setFont(Settings.smallfont);
            if (String.valueOf(this.value).length() > 6) {
                gd.drawString("" + String.valueOf(this.value).substring(0, 6), 5, 10);
            } else {
                gd.drawString("" + String.valueOf(this.value), 5, 10);
            }
        }
        if (this.drawBottomBorder) {
            gd.setColor(Color.WHITE);
            gd.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private void notifyValueChangedListeners() {
        ValueEvent e = new ValueEvent(this, this.value);
        for (int x = 0; x < this.valueChangedListeners.size(); ++x) {
            ValueChangedListener target = this.valueChangedListeners.elementAt(x);
            target.valueChanged(e);
        }
    }

    public Tweener getTweener() {
        return this.tweener;
    }

    public void setTheFloat(Tweener tweener) {
        this.tweener = tweener;
    }

    public void addValueChangedListener(ValueChangedListener l) {
        if (this.valueChangedListeners.contains(l)) {
            return;
        }
        this.valueChangedListeners.addElement(l);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        this.tweener.set(value);
    }

    public float getStartValue() {
        return this.startValue;
    }

    public void setStartValue(float startValue) {
        this.startValue = startValue;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isKeyframeAble() {
        return true;
    }

    public boolean isKeyFramed() {
        return this.tweener.isKeyframed();
    }

    public void setIsKeyFramed(boolean b) {
        this.tweener.setKeyframed(b);
        this.notifyValueChangedListeners();
    }

    public KeyFramedIF getKeyframed() {
        return null;
    }

    public KeyFramePanelIF getKeyFramePanel(ScenePanel p) {
        if (this.keyframepanel == null) {
            this.keyframepanel = new KeyFramePanelTweener(p);
        }
        this.keyframepanel.setkeys(this.tweener);
        return this.keyframepanel;
    }

    public void setAbstractLine(AbstractLine al) {
        this.abstractLine = al;
    }
}

