/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.live;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import sumo.gui.Settings;
import sumo.math.vec2i;
import sumo.v3d.BSpline;

public class Wire {
    private vec2i start = new vec2i();
    private vec2i end = new vec2i();
    int resolution = 11;
    ArrayList<vec2i> points = new ArrayList();
    ArrayList<vec2i> smoothedPoints = new ArrayList();
    BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
    BasicStroke strokeBig = new BasicStroke(5.0f, 1, 1);

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Settings.mainColor1a);
        g.setStroke(this.strokeBig);
        this.drawline(g);
        g.setColor(Color.white);
        g.setStroke(this.stroke);
        this.drawline(g);
    }

    private void drawline(Graphics2D g) {
        for (int i = 0; i < this.smoothedPoints.size() - 1; ++i) {
            g.drawLine(this.smoothedPoints.get(i).getX(), this.smoothedPoints.get(i).getY(), this.smoothedPoints.get(i + 1).getX(), this.smoothedPoints.get(i + 1).getY());
        }
    }

    private vec2i getPoint(int i) {
        if (i < 0) {
            return this.points.get(0);
        }
        if (i >= this.points.size()) {
            return this.points.get(this.points.size() - 1);
        }
        return this.points.get(i);
    }

    public void setStart(int x, int y) {
        this.start.set(x, y);
        this.recalc();
    }

    public void setEnd(int x, int y) {
        this.end.set(x, y);
        this.recalc();
    }

    private void recalc() {
        this.smoothedPoints = new ArrayList();
        this.points = new ArrayList();
        this.points.add(this.start);
        int xadd = (this.start.getX() - this.end.getX()) / -2;
        this.points.add(new vec2i(this.start.getX() + xadd, this.start.getY() - 10));
        this.points.add(new vec2i(this.end.getX() - xadd, this.end.getY() + 10));
        this.points.add(this.end);
        for (int I = 0; I <= this.points.size() - 1; ++I) {
            for (int J = 0; J <= this.resolution - 1; ++J) {
                float F = (float)J / (float)this.resolution;
                this.smoothedPoints.add(new vec2i((int)BSpline.Hermite(this.getPoint(I - 1).getX(), this.getPoint(I + 0).getX(), this.getPoint(I + 1).getX(), this.getPoint(I + 2).getX(), F), (int)BSpline.Hermite(this.getPoint(I - 1).getY(), this.getPoint(I + 0).getY(), this.getPoint(I + 1).getY(), this.getPoint(I + 2).getY(), F)));
            }
        }
    }
}

