/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.KeyDetail;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.math.vec2i;
import sumo.project.Project;
import sumoTween.KeyFloat;
import sumoTween.Tweener;

public class KeyFramePanel
extends JPanel
implements KeyFramePanelIF {
    public static boolean ignoreMouse = false;
    public static boolean usingMouse = false;
    private ScenePanel sp;
    Color bg = Color.black;
    private KeyFloat[] keys;
    private boolean mouseOver = false;
    private boolean mouseDown = false;
    private boolean mouseDragged = false;
    int mouseX = -999;
    int mouseY = -999;
    guiStopWatch watch = null;
    private int lastValue = 0;
    private int lastX = 0;
    private Tweener tweener;
    private int tempPosition;
    vec2i markedAreaStart;
    vec2i markedAreaEnd;

    public KeyFramePanel(ScenePanel s) {
        this.sp = s;
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (!ignoreMouse) {
                    if (!KeyFramePanel.this.mouseDragged && KeyFramePanel.this.mouseOverKey(e.getX()) != null) {
                        KeyFramePanel.this.mouseDragged = true;
                    }
                    if (KeyFramePanel.this.mouseDragged) {
                        KeyFramePanel.this.sp.moveMarkedKeys(KeyFramePanel.this.sp.getTimeFromPixelScreen(e.getX()).floatValue());
                    }
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (KeyFramePanel.this.keys != null) {
                    KeyFramePanel.this.mouseX = e.getX();
                    KeyFramePanel.this.mouseY = e.getY();
                    KeyFramePanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                if (KeyFramePanel.this.keys != null && KeyFramePanel.this.keys.length > 0) {
                    KeyFramePanel.this.mouseOver = true;
                    KeyFramePanel.this.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                KeyFramePanel.this.mouseOver = false;
                KeyFramePanel.this.mouseX = -999;
                KeyFramePanel.this.mouseY = -999;
                if (KeyFramePanel.this.keys != null && KeyFramePanel.this.keys.length > 0) {
                    KeyFramePanel.this.repaint();
                }
            }

            public void mousePressed(MouseEvent e) {
                KeyFloat k = KeyFramePanel.this.mouseOverKey(e.getX());
                if (k != null) {
                    usingMouse = true;
                    if (!((KeyFramePanel)KeyFramePanel.this).sp.markedKeys.contains(k)) {
                        KeyFramePanel.this.sp.resetMarkedKeys();
                        KeyFramePanel.this.sp.addMarkedKey(k);
                    }
                }
                KeyFramePanel.this.mouseDown = true;
                KeyFramePanel.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                KeyFramePanel.this.mouseDown = false;
                ((KeyFramePanel)KeyFramePanel.this).sp.keyDraggStartTime = -9999.0f;
                KeyFramePanel.this.repaint();
                usingMouse = false;
                if (!KeyFramePanel.this.mouseDragged && KeyFramePanel.this.keys != null) {
                    for (int i = 0; i < KeyFramePanel.this.keys.length; ++i) {
                        KeyFloat k = KeyFramePanel.this.keys[i];
                        int x = KeyFramePanel.this.sp.getTimeInPixel(k.getTime());
                        if (e.getX() < x + 16 && e.getX() > x - 2 && !KeyFramePanel.this.mouseDragged) {
                            KeyFramePanel.this.sp.resetMarkedKeys();
                            KeyFramePanel.this.sp.addMarkedKey(KeyFramePanel.this.keys[i]);
                            Project.getProject().setDetailPanel(new KeyDetail(((KeyFramePanel)KeyFramePanel.this).sp.markedKeys, KeyFramePanel.this.sp));
                        }
                        KeyFramePanel.this.repaint();
                    }
                }
                KeyFramePanel.this.mouseDragged = false;
            }
        });
    }

    private KeyFloat mouseOverKey(int xx) {
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                KeyFloat k = this.keys[i];
                int x = this.sp.getTimeInPixelsScreen(k.getTime());
                if (xx >= x + 8 || xx <= x - 8) continue;
                return k;
            }
        }
        return null;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_KEYFRAMEPANEL);
        }
        Graphics2D gd = (Graphics2D)g;
        this.lastValue = 0;
        this.lastX = 0;
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(Settings.borderColor);
        g.drawLine(0, 0, 0, this.getHeight());
        g.setColor(Settings.timing_cursor);
        int x = this.sp.getTimeInPixelsScreen(Project.getProject().getTime());
        g.drawLine(x, 0, x, this.getHeight());
        if (this.tweener != null && this.getHeight() > 17) {
            int lastx = 0;
            int lasty = 0;
            g.setColor(Color.black);
            for (float t = this.sp.getTimeFromPixelScreen(-10).floatValue(); t < this.sp.getTimeFromPixelScreen(this.getWidth()).floatValue(); t += 0.1f) {
                int dy = (int)(this.tweener.getNormalizedValue(t) * (float)(this.getHeight() - 1));
                int dx = this.sp.getTimeInPixelsScreen(t);
                g.drawLine(lastx, lasty, dx, dy);
                lastx = dx;
                lasty = dy;
            }
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!(this.keys[i] instanceof KeyFloat)) continue;
                KeyFloat f = this.keys[i];
                this.drawKey(g, f, f.getTime(), (int)((1.0f - f.getValue()) * (float)(this.getHeight() - 1)));
            }
        }
        if (this.markedAreaStart != null) {
            g.setColor(new Color(0.3f, 0.3f, 0.3f, 0.3f));
            g.fillRect(this.markedAreaStart.getX(), 0, this.markedAreaEnd.getX(), this.getHeight());
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private boolean drawKey(Graphics g, KeyFloat k, float time, int valueScreen) {
        boolean ret = false;
        int x = this.sp.getTimeInPixelsScreen(time) - 4;
        if (this.sp.isTimeVisible(time)) {
            if (this.mouseX < x + 8 && this.mouseX > x - 3 && !this.mouseDragged) {
                g.setColor(Settings.mainColor1);
                g.fillRoundRect(x - 2, 1, 12, this.getHeight() - 2, 4, 4);
                ret = true;
            }
            if (this.markedAreaStart != null) {
                if (x > this.markedAreaStart.getX() && x < this.markedAreaEnd.getX() + this.markedAreaStart.getX()) {
                    this.sp.addMarkedKey(k);
                } else {
                    this.sp.removeMarkedKey(k);
                }
            }
            int icon_in = 0;
            int icon_out = 0;
            if (this.sp.isMarked(k)) {
                this.sp.addMarkedKey(k);
                icon_in = Icons.KEY_MARKED_IN_BEZIER;
                icon_out = Icons.KEY_MARKED_OUT_BEZIER;
            } else {
                icon_in = Icons.KEY_IN_BEZIER;
                icon_out = Icons.KEY_OUT_BEZIER;
            }
            int y = 3;
            if (this.getHeight() > 17) {
                y = (int)((float)(this.getHeight() - 6) * k.getInternalValue() - 3.0f);
            }
            Icons.drawIcon(g, icon_in, x - 1, y);
            Icons.drawIcon(g, icon_out, x + 4, y);
        }
        this.lastX = x;
        this.lastValue = valueScreen;
        return ret;
    }

    public void setBg(Color bg) {
        this.bg = bg;
    }

    public int getNumKeys() {
        if (this.keys == null) {
            return 1;
        }
        return this.keys.length;
    }

    public void setkeys(Tweener keys) {
        System.out.println("setkeys.......");
        this.tweener = keys;
        this.keys = keys.isKeyframed() ? this.tweener.getKeys() : null;
    }

    public int getTempPosition() {
        return this.tempPosition;
    }

    public void setTempPosition(int count) {
        this.tempPosition = count;
    }

    public void setMarkedArea(int i, int j, int k, int l) {
        this.markedAreaStart = new vec2i(i, j);
        this.markedAreaEnd = new vec2i(k, l);
        this.repaint();
    }

    public void resetMarkedArea() {
        this.markedAreaEnd = null;
        this.markedAreaStart = null;
        this.repaint();
    }

    public KeyFloat[] getKeys() {
        return this.keys;
    }
}

