/*
 * Decompiled with CFR 0.152.
 */
package sumo.keyframing;

import java.util.ArrayList;
import java.util.Comparator;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyIF;
import sumo.keyframing.KeyInt;
import sumo.project.Project;
import sumo.util.Arrays;
import sumo.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyframedInt
extends KeyFramedBase
implements KeyFramedIF {
    private String name = "";
    public static String classSimpleName = "KeyframedInt";
    private int currentkey = 0;
    public String[] valueTitles = null;
    short defaultInterpolation = 0;
    private boolean allowInterpolationChange = true;
    KeyIF defaultKey = new KeyInt(0.0f, 0, this.defaultInterpolation, this);
    private boolean loop = false;
    public KeyInt[] keyframes = null;

    @Override
    public void setDefaultKey(KeyIF k) {
        this.defaultKey = k;
    }

    @Override
    public KeyIF getDefaultKey() {
        return this.defaultKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void removeAt(float f) {
        this.move(f, 9999999.0f);
        if (this.keyframes.length != 1) {
            this.keyframes = (KeyInt[])Arrays.resizeArray(this.keyframes, this.keyframes.length - 1);
        }
        this.notifyKeysChanged(this);
    }

    @Override
    public void addKey(float t, Object v) {
        this.change(t, (Integer)v);
        this.notifyKeysChanged(this);
    }

    @Override
    public KeyIF[] getKeys() {
        return this.keyframes;
    }

    public KeyframedInt() {
        this.clear();
    }

    public KeyframedInt(String n) {
        this.setName(n);
        this.clear();
    }

    public void setValue(int i) {
        this.change(Project.getProject().getTime(), i);
        this.notifyKeysChanged(this);
    }

    @Override
    public void insertKey(KeyIF k) {
        this.change(k.getTime(), ((KeyInt)k).getValue());
        this.notifyKeysChanged(this);
    }

    public void change(KeyInt k) {
        this.change(k.time, k.value);
        this.notifyKeysChanged(this);
    }

    public void sortKeys() {
        java.util.Arrays.sort(this.keyframes, new Comparator(){

            public int compare(Object a, Object b) {
                KeyInt ia = (KeyInt)a;
                KeyInt ib = (KeyInt)b;
                if (ia.time > ib.time) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void change(float t, int v) {
        if (!this.isKeyframed) {
            this.keyframes[0].value = v;
        } else {
            boolean found = false;
            for (int i = 0; i < this.keyframes.length; ++i) {
                if (t != this.keyframes[i].time) continue;
                this.keyframes[i].value = v;
                found = true;
            }
            if (!found) {
                Log.log("key not found...");
                this.keyframes = (KeyInt[])Arrays.resizeArray(this.keyframes, this.keyframes.length + 1);
                this.keyframes[this.keyframes.length - 1] = new KeyInt(t, v, this.defaultInterpolation, this);
            }
            this.sortKeys();
        }
        this.notifyKeysChanged(this);
    }

    public int getValue() {
        return this.getValue(Project.getProject().getTime());
    }

    @Override
    public void move(float t, float t2) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (t != this.keyframes[i].time) continue;
            this.keyframes[i].time = t2;
            break;
        }
        this.sortKeys();
        this.notifyKeysChanged(this);
    }

    public int getCurrentkey() {
        return this.currentkey;
    }

    public int getValue(float time) {
        if (!this.isKeyframed) {
            this.currentkey = 0;
            return this.keyframes[0].value;
        }
        if (this.keyframes.length == 1) {
            this.currentkey = 0;
            return this.keyframes[0].value;
        }
        int which = 0;
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!(this.keyframes[i].time <= time)) continue;
            which = i;
        }
        if (this.currentkey < this.keyframes.length) {
            if (this.keyframes[this.currentkey].getModeIn() == 0) {
                if (which == -1 || which == this.keyframes.length - 1) {
                    this.currentkey = this.keyframes.length - 1;
                    return this.keyframes[this.keyframes.length - 1].value;
                }
                int next = which + 1;
                float r = (time - this.keyframes[which].time) / (this.keyframes[next].time - this.keyframes[which].time);
                this.currentkey = which;
                return this.keyframes[which].value + (int)(r * (float)(this.keyframes[next].value - this.keyframes[which].value));
            }
            if (this.keyframes[this.currentkey].getModeIn() == 1) {
                this.currentkey = which;
                return this.keyframes[which].value;
            }
        }
        return 0;
    }

    public void setValueTitles(String[] s) {
        this.valueTitles = s;
    }

    @Override
    public short getDefaultInterpolationMode() {
        return this.defaultInterpolation;
    }

    @Override
    public void setDefaultInterpolationMode(short m) {
        this.defaultInterpolation = m;
    }

    @Override
    public boolean isAllowInterpolationChange() {
        return this.allowInterpolationChange;
    }

    @Override
    public void setAllowInterpolationChange(boolean allowInterpolationChange) {
        this.allowInterpolationChange = allowInterpolationChange;
    }

    @Override
    public void deleteKeys(ArrayList<KeyIF> markedKeys) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!markedKeys.contains(this.keyframes[i])) continue;
            this.removeAt(this.keyframes[i].getTime());
        }
        this.notifyKeysChanged(this);
    }

    public String getValueTitle() {
        int v = this.getValue();
        if (v >= 0 && this.valueTitles != null) {
            if (this.valueTitles.length > v) {
                return this.valueTitles[v];
            }
            return "none (" + v + ")";
        }
        return String.valueOf(v);
    }

    @Override
    public String getClassSimpleName() {
        return classSimpleName;
    }

    @Override
    public void clear() {
        this.keyframes = new KeyInt[1];
        this.keyframes[0] = new KeyInt(this.defaultKey.getTime(), ((KeyInt)this.defaultKey).getValue(), this.defaultInterpolation, this);
        this.notifyKeysChanged(this);
    }

    @Override
    public void invokeChangeListener() {
        this.notifyKeysChanged(this);
    }
}

