/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import sumo.project.Project;

public class common {
    public static boolean debugOpenGL = false;

    public static void glInit(int width, int height) {
        GL11.glShadeModel(7425);
        GL11.glClearDepth(999999.0);
        GL11.glEnable(2929);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)width / (float)height, 0.2f, 1000.0f);
        GL11.glMatrixMode(5888);
        GL11.glHint(3152, 4354);
    }

    public static void switchTo2d() {
        common.switchTo2d(Project.getProject().getOpenGLSsettings().getWidth(), Project.getProject().getOpenGLSsettings().getHeight(), false);
    }

    public static void switchTo2d(int width, int height, boolean ratio) {
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        float r = 1.7777778f;
        if (ratio) {
            r = (float)width / (float)height;
        }
        GLU.gluPerspective(45.0f, r, 0.1f, 100000.0f);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, width, 0.0f, height);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
    }

    public static void switchTo2dd() {
        common.switchTo2dd(Project.getProject().getOpenGLSsettings().getWidth(), Project.getProject().getOpenGLSsettings().getHeight());
    }

    public static void switchTo2dd(int width, int height) {
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GLU.gluPerspective(45.0f, 1.7777778f, 0.1f, 100000.0f);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D(0.0f, width, height, 0.0f);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
    }

    public static void switchTo3d() {
        GL11.glDisable(3553);
        GL11.glDisable(3042);
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
        GL11.glEnable(2929);
    }

    public static String screenShot(String path, String filename, String format, int width, int height) {
        ByteBuffer fb = ByteBuffer.allocateDirect(width * height * 3);
        int[] pixels = new int[width * height];
        GL11.glReadPixels(0, 0, width, height, 6407, 5120, fb);
        for (int i = 0; i < pixels.length; ++i) {
            int bindex = i * 3;
            pixels[i] = (fb.get(bindex) * 2 << 16) + (fb.get(bindex + 1) * 2 << 8) + (fb.get(bindex + 2) * 2 << 0);
        }
        try {
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, pixels, 0, width);
            image = common.flipImage(image);
            filename = path + filename + "." + format;
            System.out.println("screenshot: " + filename);
            ImageIO.write((RenderedImage)image, format, new File(filename));
        }
        catch (Exception e) {
            System.out.println("ScreenShot() exception: " + e);
        }
        return filename;
    }

    public static BufferedImage flipImage(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bi = op.filter(bi, null);
        return bi;
    }

    public static float smoothStep(float x) {
        return x * x * (3.0f - 2.0f * x);
    }
}

