/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.playScene;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.math.vec2f;
import sumo.opengl.OpenGLSettings;
import sumo.plugin.Plugin;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.shader.ShaderPartProgram;
import sumo.shader.ShaderVariable;
import sumo.shader.SumoShader;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.events.TweenEvent;

public class PlayScene
extends Plugin
implements PluginIF {
    public Tweener speed;
    public Tweener whichscene;
    public Tweener effect;
    public KeyframedResource shader;
    ArrayList<Tweener> shadervalues = new ArrayList();
    SumoShader sshader;
    int currentscene = -1;
    int lastscene = -1;
    float starttime;
    boolean inited = false;
    OpenGLSettings gl;

    public String getName() {
        return "playscene";
    }

    public String getAuthor() {
        return "pandur";
    }

    public float getVersion() {
        return 1.0f;
    }

    public void init() {
        this.effect.setTitleValues(new String[]{"none"});
        this.shader.setResource(new sShader());
        this.shader.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                PlayScene.this.sshader = ((sShader)PlayScene.this.shader.getResource()).getSumoShader();
                ArrayList<ShaderPartProgram> shaderprogs = PlayScene.this.sshader.getProgramms();
                ArrayList<String> titles = new ArrayList<String>();
                PlayScene.this.shadervalues = new ArrayList();
                titles.add("none");
                PlayScene.this.shadervalues.add(null);
                for (ShaderPartProgram prog : shaderprogs) {
                    ArrayList<ShaderVariable> vars = prog.getUniforms();
                    for (ShaderVariable var : vars) {
                        System.out.println(var.getName());
                    }
                }
                PlayScene.this.effect.setTitleValues(titles.toArray(new String[0]));
            }
        });
        this.whichscene.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                int i;
                for (i = 0; i < Project.getProject().getNumScenes(); ++i) {
                    Project.getProject().getScene(i).clearTimeAreas();
                }
                for (i = 0; i < PlayScene.this.whichscene.getKeys().length - 1; ++i) {
                    KeyFloat sc = PlayScene.this.whichscene.getKeys()[i];
                    Project.getProject().getScene((int)sc.getValue()).addTimeArea(new vec2f(PlayScene.this.whichscene.getKeys()[i].getTime(), PlayScene.this.whichscene.getKeys()[i + 1].getTime()));
                }
            }

            public void finished() {
            }
        });
    }

    public void renderScene(int which) {
        if (which != Project.getProject().getCurrentSceneNum() && which >= 0 && which < Project.getProject().getNumScenes()) {
            Project.getProject().getScene(which).render();
        }
    }

    public void render() {
        GL11.glClear(16640);
        this.renderScene(this.whichscene.getIntValue());
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

