/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.v3dplayer;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.gui.AbstractLine;
import sumo.gui.lineTypeElements.guiResource;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.resource.types.v3d;
import sumo.v3d.BSpline;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.material.Material;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumo.v3d.mesh.Object;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.Cubic;
import sumoTween.events.TweenEvent;

public class Main
extends Plugin {
    public Tweener animScratch;
    public Tweener camShake;
    public Tweener camFOV;
    public Tweener camRoll;
    public Scene s = null;
    public KeyframedResource scene;
    public Tweener camera;
    public KeyframedBoolean background;
    public KeyframedBoolean cleardepth;
    public KeyframedBoolean animRestart;
    public KeyframedBoolean shadows;
    public Tweener shadows_offsetunits;
    public Tweener shadows_offsetfactor;
    public Tweener shadows_opacity;
    public KeyframedBoolean shadows_lightcam;
    public Tweener addposp;
    public Tweener addposy;
    public Tweener addposx;
    public Tweener addposz;
    public Tweener addpostimerange;
    public Tweener timingMode;
    private int oldcam = 0;
    Vec3fkeyframed smoothKeys;
    Vec3fkeyframed smoothKeys2;
    private static final int TIMING_NORMAL = 0;
    private static final int TIMING_SCRATCH = 1;
    private static final int TIMING_FREELOOP = 2;
    ArrayList<String> dynamicMaterialsStrings = new ArrayList();
    ArrayList<String> dynamicShader = new ArrayList();
    ArrayList<Material> dynamicShaderMaterials = new ArrayList();
    ArrayList<sShader> dynamicShaderShaders = new ArrayList();
    float[] biasMatrix = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
    boolean addPosInited = false;
    ArrayList<AbstractLine> lines = new ArrayList();
    AbstractLine folderMaterial = null;

    public void init() {
        this.smoothKeys = this.getCamShake(50.0f);
        this.smoothKeys2 = this.getCamShake(20.0f);
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                Main.this.s = ((v3d)Main.this.scene.getResource()).getScene();
                Main.this.camera.setTitleValues(Main.this.s.getCameraTitles());
                for (Material material : Main.this.s.getMaterials()) {
                }
                Main.this.dynamicMaterialsStrings.clear();
                Main.this.dynamicShader.clear();
                Main.this.getAbstractLine().rebuildPluginPanel();
            }
        });
        this.timingMode.setTitleValues(new String[]{"normal", "scratch", "free loop"});
        this.timingMode.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                if (Main.this.timingMode.getIntValue() == 0) {
                    Main.this.animScratch.setEnabled(false);
                    Main.this.animRestart.setEnabled(true);
                } else if (Main.this.timingMode.getIntValue() == 1) {
                    Main.this.animScratch.setEnabled(true);
                    Main.this.animRestart.setEnabled(false);
                } else {
                    Main.this.animScratch.setEnabled(false);
                    Main.this.animRestart.setEnabled(false);
                }
            }

            public void finished() {
            }
        });
        this.shadows.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                if (Main.this.s != null) {
                    Main.this.s.shadowed = Main.this.shadows.getKeyframedValue();
                }
            }
        });
        this.addposp.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposy.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposx.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposz.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addpostimerange.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
    }

    public void render() {
        GL11.glClearDepth(999999.0);
        if (this.cleardepth.getKeyframedValue()) {
            GL11.glClear(256);
        }
        if (this.background.getKeyframedValue() && this.s != null) {
            GL11.glClearColor(this.s.backgroundcolor.x, this.s.backgroundcolor.y, this.s.backgroundcolor.z, 1.0f);
            GL11.glClear(16384);
        }
        if (this.s != null) {
            if (this.camera.getValue() != (float)this.oldcam || this.camera.getValue() != (float)this.s.getCamNum()) {
                this.s.setCam(this.camera.getIntValue());
                this.oldcam = this.camera.getIntValue();
            }
            this.setDynamicMaterials();
            if (this.camShake.getValue() != 0.0f) {
                if (this.s.getCam(this.camera.getIntValue()) != null) {
                    this.s.getCam((int)this.camera.getIntValue()).eyeAdd = this.smoothKeys;
                    this.s.getCam((int)this.camera.getIntValue()).targetAdd = this.smoothKeys2;
                    this.s.getCam((int)this.camera.getIntValue()).addMul = this.camShake.getValue() * 2.0f;
                }
            } else if (this.s.getCam(this.camera.getIntValue()) != null) {
                this.s.getCam((int)this.camera.getIntValue()).eyeAdd = null;
                this.s.getCam((int)this.camera.getIntValue()).targetAdd = null;
            }
            if (this.s.getCam(this.camera.getIntValue()) != null) {
                this.s.getCam((int)this.camera.getIntValue()).myfov = this.camFOV.isEnabled() ? 90.0f * this.camFOV.getValue() : -1.0f;
                this.s.getCam((int)this.camera.getIntValue()).roll = this.camRoll.isEnabled() ? 90.0f * this.camRoll.getValue() : 0.0f;
            }
            this.renderScene();
            if (this.s.shadowed) {
                this.s.shadow.polyOffsetFactor = this.shadows_offsetfactor.getValue() * 4.0f;
                this.s.shadow.polyOffsetUnits = this.shadows_offsetunits.getValue() * 8.0f;
            }
        }
        GL11.glDisable(2896);
    }

    private void setDynamicMaterials() {
        for (int i = 0; i < this.dynamicShaderMaterials.size(); ++i) {
            this.dynamicShaderMaterials.get((int)i).settings.opacity = 0.99f;
            this.dynamicShaderMaterials.get((int)i).sShader = this.dynamicShaderShaders.get(i);
        }
    }

    private void renderScene() {
        if (this.addposp.isEnabled() && !this.addPosInited) {
            this.updateMeshPosAdd();
        }
        if (this.timingMode.getIntValue() == 1) {
            this.s.render(this.s.animLength * this.animScratch.getValue());
        } else if (this.timingMode.getIntValue() == 2) {
            float f = (float)Sys.getTime() / 1000.0f % this.s.animLength;
            this.s.render(f);
        } else {
            float f = Project.getProject().getTime() - this.animRestart.getKey(Project.getProject().getTime()).getTime();
            this.s.render(f);
        }
    }

    public String getAuthor() {
        return null;
    }

    public float getVersion() {
        return 0.0f;
    }

    public Vec3fkeyframed getCamShake(float max) {
        ArrayList<Vec3f> points = new ArrayList<Vec3f>();
        for (int i = 0; i < 100; ++i) {
            points.add(new Vec3f((float)Math.random() * max * 2.0f - max, (float)Math.random() * max * 2.0f - max, (float)Math.random() * max * 2.0f - max));
        }
        BSpline spline = new BSpline(points);
        spline.setResolution(5);
        spline.calc();
        ArrayList<Vec3f> smoothPoints = spline.getSmoothedPoints();
        Vec3fkeyframed smoothKeys = new Vec3fkeyframed();
        for (int i = 0; i < smoothPoints.size(); ++i) {
            float time = (float)i / 20.0f;
            smoothKeys.x.setValue(time, smoothPoints.get((int)i).x);
            smoothKeys.y.setValue(time, smoothPoints.get((int)i).y);
            smoothKeys.z.setValue(time, smoothPoints.get((int)i).z);
        }
        return smoothKeys;
    }

    private void addMaterialLine(Material m) {
        if (this.folderMaterial == null) {
            this.folderMaterial = new AbstractLine(this.getAbstractLine().pluginPanel, this, 2, "materials", null);
            this.getAbstractLine().childs.add(this.folderMaterial);
        }
        KeyframedResource r = new KeyframedResource();
        for (int i = 0; i < this.dynamicMaterialsStrings.size(); ++i) {
            if (!m.title.equals(this.dynamicMaterialsStrings.get(i))) continue;
            sShader shr = (sShader)Project.getProject().getResourceManager().getResourceByFileName(this.dynamicShader.get(i));
            Material mm = this.s.getMaterialByTitle(this.dynamicMaterialsStrings.get(i));
            if (m == null) {
                System.out.println("MATERIAL DOES NOT EXIST!!!" + this.dynamicMaterialsStrings.get(i));
            } else {
                mm.sShader = shr;
            }
            this.dynamicShaderMaterials.add(mm);
            this.dynamicShaderShaders.add(shr);
        }
        if (m.sShader != null) {
            r.setResource(m.sShader);
        } else {
            r.setResource(new sShader());
        }
        r.setData(m);
        guiResource f = new guiResource(r);
        r.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                Material m = (Material)keyframed.getData();
                m.sShader = (sShader)((KeyframedResource)keyframed).getResource();
                Main.this.dynamicShaderMaterials.add(m);
                Main.this.dynamicShaderShaders.add(m.sShader);
            }
        });
        AbstractLine al = new AbstractLine(this.getAbstractLine().pluginPanel, this, 0, m.title, f);
        this.lines.add(al);
        this.folderMaterial.childs.add(al);
    }

    public void saveXML(Element root) {
        this.setDynamicMaterials();
        for (Material m : this.dynamicShaderMaterials) {
            Element eMaterial = root.getOwnerDocument().createElement("material");
            eMaterial.setAttribute("title", m.title);
            eMaterial.setAttribute("shader", m.sShader.getFilename());
            root.appendChild(eMaterial);
        }
    }

    public void loadXML(Element root) {
        if (root == null) {
            return;
        }
        NodeList nl = root.getElementsByTagName("material");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            String t = e.getAttribute("title");
            String sh = e.getAttribute("shader");
            this.dynamicMaterialsStrings.add(t);
            this.dynamicShader.add(sh);
        }
    }

    public String getSubTitle() {
        if (this.scene != null) {
            return this.scene.getResource().getFilename();
        }
        return null;
    }

    private void updateMeshPosAdd() {
        if (this.s == null) {
            return;
        }
        this.addPosInited = true;
        System.out.println("a");
        List<NodeIF> i = this.s.getMeshes();
        boolean count = false;
        for (NodeIF nodeIF : i) {
            Object o = (Object)nodeIF;
            if (this.addposp.isEnabled()) {
                float t;
                float f;
                int j;
                KeyFloat[] keys;
                o.posAdd = new VEC3Tweened(new Cubic(), Project.getProject().getTimer());
                if (this.addposz.isEnabled()) {
                    keys = this.addposx.getKeys();
                    for (j = 0; j < keys.length; ++j) {
                        f = (float)((double)(o.pos.x * 5.0f) + Math.random() * (double)o.pos.x * 30.0) * keys[j].getValue();
                        t = (float)Math.random();
                        o.posAdd.x.set(keys[j].getTime() + t, f, 2);
                        System.out.println(this.addpostimerange.getValue() + "!!!!!!!!!!" + t);
                    }
                    o.posAdd.x.printKeys();
                }
                if (this.addposy.isEnabled()) {
                    keys = this.addposy.getKeys();
                    for (j = 0; j < keys.length; ++j) {
                        f = (float)((double)(o.pos.y * 5.0f) + Math.random() * (double)o.pos.y * 30.0) * keys[j].getValue();
                        t = (float)Math.random();
                        o.posAdd.y.set(keys[j].getTime() + t, f, 2);
                    }
                }
                if (!this.addposz.isEnabled()) continue;
                keys = this.addposz.getKeys();
                for (j = 0; j < keys.length; ++j) {
                    f = (float)((double)(o.pos.z * 5.0f) + Math.random() * (double)o.pos.z * 30.0) * keys[j].getValue();
                    t = (float)Math.random();
                    o.posAdd.z.set(keys[j].getTime() + t, f, 2);
                }
                continue;
            }
            o.posAdd = null;
        }
    }
}

