/*
 * Decompiled with CFR 0.152.
 */
package sumo.shader;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.shader.PartFragment;
import sumo.shader.PartVertex;
import sumo.shader.ShaderListener;
import sumo.shader.ShaderPartProgram;
import sumo.shader.ShaderTexture;
import sumo.shader.ShaderVariable;
import sumo.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumoShader {
    int fragShaderID = -1;
    int vertShaderID = -1;
    public boolean alpha = false;
    private boolean autoRecompile = true;
    public static final int SHADER_FRAGMENT = 0;
    public static final int SHADER_VERTEX = 1;
    boolean needsRecompile = false;
    String compilerOutput = "";
    private ArrayList<ShaderPartProgram> partProgramms = new ArrayList();
    private ArrayList<ShaderListener> changeListener = new ArrayList();
    String path = "shader/parts/";
    int programObject = -1;
    ShaderTexture[] multitexture = new ShaderTexture[]{new ShaderTexture(), new ShaderTexture(), new ShaderTexture(), new ShaderTexture()};
    public String title = "";
    boolean updateTextureLocs = false;
    int shaderTimeLoc = 0;

    public ArrayList<ShaderPartProgram> getProgramms() {
        return this.partProgramms;
    }

    public void setNeedsRecompile() {
        this.needsRecompile = true;
    }

    public ShaderPartProgram addPartFilename(String filename) {
        ShaderPartProgram pr = new ShaderPartProgram(this, filename);
        this.partProgramms.add(pr);
        this.needsRecompile = true;
        this.updatePartsAutorecompile();
        return pr;
    }

    public void addPart(String partname) {
        this.addPartFilename(this.path + partname + ".xml");
    }

    public void setMultiTexture(int multi, int tid, String target) {
        this.setMultiTexture(multi, tid, target, 34037);
    }

    public void setMultiTexture(int multi, int tid, String target, int type) {
        this.multitexture[multi].texture = tid;
        this.multitexture[multi].type = type;
        this.multitexture[multi].settarget(target);
        this.updateTextureLocs = true;
    }

    public int getMultiTexture(int multi) {
        return this.multitexture[multi].texture;
    }

    public void bind() {
        int i;
        if (this.alpha) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        }
        if (this.partProgramms.size() == 0) {
            return;
        }
        if (this.needsRecompile) {
            this.recompile();
        }
        if (this.programObject == -1) {
            return;
        }
        for (i = 0; i < this.multitexture.length; ++i) {
            int multi = this.multitexture[i].texture;
            if (multi == -1) continue;
            if (i == 0) {
                GL13.glActiveTexture(33984);
            }
            if (i == 1) {
                GL13.glActiveTexture(33985);
            }
            if (i == 2) {
                GL13.glActiveTexture(33986);
            }
            if (i == 3) {
                GL13.glActiveTexture(33987);
            }
            this.multitexture[i].enable();
            this.multitexture[i].bind();
        }
        ARBShaderObjects.glUseProgramObjectARB(this.programObject);
        if (this.updateTextureLocs) {
            for (i = 0; i < this.multitexture.length; ++i) {
                this.updateTextureLocs = false;
                if (this.multitexture[i].texture == -1) continue;
                int li = this.multitexture[i].getTargetLoc(this);
                ARBShaderObjects.glUniform1iARB(li, i);
            }
        }
        if (this.shaderTimeLoc == 0) {
            this.shaderTimeLoc = this.setUniformLocation("time");
            if (this.shaderTimeLoc == 0) {
                this.shaderTimeLoc = -1;
            }
        }
        if (this.shaderTimeLoc > 0) {
            this.setUniform1f(this.shaderTimeLoc, Project.getProject().getTime());
        }
    }

    public void unbind() {
        if (this.alpha) {
            GL11.glDisable(3042);
        }
        if (this.multitexture[0].texture != -1) {
            for (int i = 0; i < this.multitexture.length; ++i) {
                int multi = this.multitexture[i].texture;
                if (multi == -1) continue;
                GL11.glEnable(34037);
                if (i == 0) {
                    GL13.glActiveTexture(33984);
                }
                if (i == 1) {
                    GL13.glActiveTexture(33985);
                }
                if (i == 2) {
                    GL13.glActiveTexture(33986);
                }
                if (i == 3) {
                    GL13.glActiveTexture(33987);
                }
                GL11.glBindTexture(34037, 0);
                GL11.glDisable(34037);
                GL13.glActiveTexture(33984);
            }
            GL11.glDisable(34037);
        }
        ARBShaderObjects.glUseProgramObjectARB(0);
    }

    public void recompile() {
        this.shaderTimeLoc = 0;
        this.needsRecompile = false;
        this.compilerOutput = "";
        if (this.partProgramms.size() != 0) {
            this.unbind();
            String logstring = "";
            System.out.println("recompiling shaderprogram...");
            if (this.programObject == -1) {
                this.programObject = ARBShaderObjects.glCreateProgramObjectARB();
            }
            System.out.println("compiling vertex shader...");
            ARBShaderObjects.glDetachObjectARB(this.programObject, this.vertShaderID);
            this.vertShaderID = this.compile(this.getVertexCode(), 1, this.vertShaderID);
            ARBShaderObjects.glAttachObjectARB(this.programObject, this.vertShaderID);
            System.out.println("compiling fragment shader...");
            ARBShaderObjects.glDetachObjectARB(this.programObject, this.fragShaderID);
            this.fragShaderID = this.compile(this.getFragmentCode(), 0, this.fragShaderID);
            ARBShaderObjects.glAttachObjectARB(this.programObject, this.fragShaderID);
            int er = GL11.glGetError();
            if (er != 0) {
                if (er == 1281) {
                    System.out.println("__ GL_INVALID_VALUE");
                }
                if (er == 1282) {
                    System.out.println("__ GL_INVALID_OPERATION");
                }
                System.out.println("error");
            }
            logstring = logstring + "attaching shader: \n";
            this.printShaderObjectInfoLog(this.programObject);
            ARBShaderObjects.glLinkProgramARB(this.programObject);
            this.printShaderObjectInfoLog(this.programObject);
            ARBShaderObjects.glValidateProgramARB(this.programObject);
            this.printShaderObjectInfoLog(this.programObject);
        }
        for (int x = 0; x < this.changeListener.size(); ++x) {
            ShaderListener l = this.changeListener.get(x);
            l.recompiled();
        }
    }

    public void addShaderListener(ShaderListener cl) {
        if (this.changeListener.contains(cl)) {
            return;
        }
        this.changeListener.add(cl);
    }

    public int compile(String s, int type, int shaderID) {
        int which = -1;
        which = type == 0 ? 35632 : 35633;
        if (shaderID == -1) {
            shaderID = ARBShaderObjects.glCreateShaderObjectARB(which);
        }
        ARBShaderObjects.glShaderSourceARB(shaderID, ByteBuffer.wrap(s.getBytes()));
        ARBShaderObjects.glCompileShaderARB(shaderID);
        System.out.println("shader compiled :" + shaderID + " ()");
        int er = GL11.glGetError();
        if (er != 0) {
            // empty if block
        }
        return shaderID;
    }

    public void printShaderObjectInfoLog(int ID) {
        IntBuffer programBuffer = BufferUtils.createIntBuffer(1);
        ARBShaderObjects.glGetObjectParameterARB(ID, 35716, programBuffer);
        int logLength = programBuffer.get(0);
        if (logLength <= 1) {
            return;
        }
        ByteBuffer log = BufferUtils.createByteBuffer(logLength);
        ARBShaderObjects.glGetInfoLogARB(ID, null, log);
        byte[] charArray = new byte[logLength];
        log.get(charArray);
        Log.log("shader compiler output:" + new String(charArray, 0, logLength));
        this.compilerOutput = this.compilerOutput + new String(charArray, 0, logLength);
    }

    public int setUniformLocation(String which) {
        int l = ARBShaderObjects.glGetUniformLocationARB(this.programObject, SumoShader.toByteString(which, true));
        System.out.println("setuniformlocation: " + which + ":" + l);
        return l;
    }

    public static ByteBuffer toByteString(String str, boolean isNullTerminated) {
        int length = str.length();
        if (isNullTerminated) {
            ++length;
        }
        ByteBuffer buff = BufferUtils.createByteBuffer(length);
        buff.put(str.getBytes());
        if (isNullTerminated) {
            buff.put((byte)0);
        }
        buff.flip();
        return buff;
    }

    public void setUniform4fv(int loc, FloatBuffer fb) {
        if (loc != -1) {
            ARBShaderObjects.glUniform4ARB(loc, fb);
        }
    }

    public void setUniform2f(int loc, float x, float y) {
        if (loc != -1) {
            ARBShaderObjects.glUniform2fARB(loc, x, y);
        }
    }

    public void setUniform1f(int loc, float f) {
        if (loc != -1) {
            ARBShaderObjects.glUniform1fARB(loc, f);
        }
    }

    public void setUniform1i(int loc, int f) {
        if (loc != -1) {
            ARBShaderObjects.glUniform1iARB(loc, f);
        }
    }

    public static void createShaderResource() {
        String f = "new shader";
        String ff = "new shader";
        int fni = 0;
        while (Project.getProject().getResourceManager().getResourceByFileName(f) != null) {
            f = ff + " " + ++fni;
        }
        sShader s = new sShader();
        s.filename = f;
        Project.getProject().getResourceManager().addNoCheck(s);
    }

    public String getFragmentCode() {
        ShaderVariable v;
        String s;
        String fsHead = "";
        String fsCode = "";
        String fsMain = "";
        for (PartFragment f : this.getAllFragments()) {
            if (f == null || fsCode.contains(f.getFunctionsCode())) continue;
            fsCode = fsCode + f.getFunctionsCode();
        }
        int rand = 0;
        String uniform_textures = "";
        for (PartFragment f : this.getAllFragments()) {
            String s2;
            int i;
            if (f == null) continue;
            for (i = 0; i < f.getTextureNames().size(); ++i) {
                s = "uniform sampler2DRect _ctex0" + f.getTextureNums()[i] + ";\n";
                if (uniform_textures.contains(s)) continue;
                uniform_textures = uniform_textures + s;
            }
            for (i = 0; i < f.getUniforms().size(); ++i) {
                v = (ShaderVariable)f.getUniforms().get(i);
                s2 = "uniform " + v.getType() + " " + v.getNameForCode() + ";\n";
                uniform_textures = uniform_textures + s2;
            }
            for (i = 0; i < f.getVaryings().size(); ++i) {
                v = (ShaderVariable)f.getVaryings().get(i);
                s2 = "varying " + v.getType() + " " + v.getNameForCode() + ";\n";
                uniform_textures = uniform_textures + s2;
            }
        }
        for (PartFragment f : this.getAllFragments()) {
            int i;
            if (f == null) continue;
            fsHead = fsHead + f.getHeadCode();
            fsCode = fsCode + f.getCode(++rand);
            for (i = 0; i < f.getTextureNames().size(); ++i) {
                s = (String)f.getTextureNames().get(i);
                fsCode = fsCode.replaceAll("\\" + s + "", "_ctex0" + f.getTextureNums()[i]);
                fsHead = fsHead.replaceAll("\\" + s + "", "_ctex0" + f.getTextureNums()[i]);
            }
            for (i = 0; i < f.getUniforms().size(); ++i) {
                v = (ShaderVariable)f.getUniforms().get(i);
                fsCode = fsCode.replaceAll("\\" + v.getName(), v.getNameForCode());
            }
            for (i = 0; i < f.getVaryings().size(); ++i) {
                v = (ShaderVariable)f.getVaryings().get(i);
                fsCode = fsCode.replaceAll("\\" + v.getName(), v.getNameForCode());
            }
            fsMain = fsMain + "\t";
            String blends = "=";
            if (f.getBlend_mode() == 1) {
                blends = "+=";
            }
            if (f.getBlend_mode() == 2) {
                blends = "-=";
            }
            if (f.getBlend_mode() == 3) {
                blends = "*=";
            }
            fsMain = fsMain + "color " + blends + " main_" + f.getTitle() + "_" + rand + "(color);";
            fsMain = fsMain + "\n";
        }
        fsMain = uniform_textures + "\n" + fsHead + "" + fsCode + "\n\r\n\r" + "void main(){\n\tvec4 color=vec4(0,0,0,0);\n" + fsMain + "\n\tgl_FragColor=color; \n\r}";
        return fsMain;
    }

    public String getVertexCode() {
        ShaderVariable v;
        String s;
        int i;
        String fsHead = "";
        String fsCode = "";
        String fsMain = "";
        for (PartVertex f : this.getAllVertex()) {
            if (f == null || fsCode.contains(f.getFunctionsCode())) continue;
            fsCode = fsCode + f.getFunctionsCode();
        }
        if (this.getAllVertex().size() == 0) {
            System.out.println("AHA!");
        }
        int rand = 0;
        String uniform_textures = "";
        for (PartVertex f : this.getAllVertex()) {
            String s2;
            if (f == null) continue;
            for (i = 0; i < f.getTextureNames().size(); ++i) {
                s = "uniform sampler2DRect _ctex0" + f.getTextureNums()[i] + ";\n";
                if (uniform_textures.contains(s)) continue;
                uniform_textures = uniform_textures + s;
            }
            for (i = 0; i < f.getUniforms().size(); ++i) {
                v = (ShaderVariable)f.getUniforms().get(i);
                s2 = "uniform " + v.getType() + " " + v.getNameForCode() + ";\n";
                uniform_textures = uniform_textures + s2;
            }
            for (i = 0; i < f.getVaryings().size(); ++i) {
                v = (ShaderVariable)f.getVaryings().get(i);
                s2 = "varying " + v.getType() + " " + v.getNameForCode() + ";\n";
                uniform_textures = uniform_textures + s2;
            }
        }
        for (PartVertex f : this.getAllVertex()) {
            if (f == null) continue;
            fsHead = fsHead + f.getHeadCode();
            fsCode = fsCode + f.getCode(++rand);
            for (i = 0; i < f.getTextureNames().size(); ++i) {
                s = (String)f.getTextureNames().get(i);
                fsCode = fsCode.replaceAll("\\" + s + "", "_ctex0" + f.getTextureNums()[i]);
                fsHead = fsHead.replaceAll("\\" + s + "", "_ctex0" + f.getTextureNums()[i]);
            }
            for (i = 0; i < f.getUniforms().size(); ++i) {
                v = (ShaderVariable)f.getUniforms().get(i);
                fsCode = fsCode.replaceAll("\\" + v.getName(), v.getNameForCode());
            }
            for (i = 0; i < f.getVaryings().size(); ++i) {
                v = (ShaderVariable)f.getVaryings().get(i);
                fsCode = fsCode.replaceAll("\\" + v.getName(), v.getNameForCode());
            }
            fsMain = fsMain + "\t";
            fsMain = fsMain + "pos=main_" + f.getTitle() + "_" + rand + "(pos);";
            fsMain = fsMain + "\n";
        }
        if (fsMain.equals("")) {
            fsMain = "\tpos=ftransform();";
        }
        fsMain = uniform_textures + fsHead + "" + fsCode + "\n\r\n\r" + "void main(){\n\tgl_TexCoord[0] = gl_MultiTexCoord0;\n\tgl_TexCoord[1] = gl_MultiTexCoord1;\n\tvec4 pos=vec4(0,0,0,0);\n" + fsMain + "\n\tgl_Position =pos; \n\r}";
        return fsMain;
    }

    private ArrayList<PartVertex> getAllVertex() {
        ArrayList<PartVertex> l = new ArrayList<PartVertex>();
        for (ShaderPartProgram p : this.partProgramms) {
            l.add(p.getVertexPart());
        }
        return l;
    }

    private ArrayList<PartFragment> getAllFragments() {
        ArrayList<PartFragment> l = new ArrayList<PartFragment>();
        for (ShaderPartProgram p : this.partProgramms) {
            l.add(p.getFragmentPart());
        }
        return l;
    }

    public String getCompilerOutput() {
        return this.compilerOutput;
    }

    public void remove(ShaderPartProgram shaderPart) {
        this.partProgramms.remove(shaderPart);
        this.needsRecompile = true;
    }

    public boolean getAutoRecompile() {
        return this.autoRecompile;
    }

    public void setAutoRecompile(boolean auto) {
        this.autoRecompile = auto;
        for (ShaderPartProgram p : this.partProgramms) {
            p.setAutoReload(auto);
        }
    }

    private void updatePartsAutorecompile() {
        for (ShaderPartProgram p : this.partProgramms) {
            if (p.isAutoReloaded() == this.autoRecompile) continue;
            p.setAutoReload(this.autoRecompile);
        }
    }

    public boolean getNeedsRecompile() {
        return this.needsRecompile;
    }

    public void setPath(String p) {
        this.path = p;
    }
}

