/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import sumo.project.Project;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Vec3fkeyframed;

public class Camera
extends Node
implements NodeIF {
    public float fov = 45.0f;
    public Vec3fkeyframed eye = new Vec3fkeyframed();
    public Vec3fkeyframed target = new Vec3fkeyframed();
    public float znear = 0.2f;
    public float zfar = 1000.0f;
    public float roll = 0.0f;
    public Vec3fkeyframed eyeAdd = new Vec3fkeyframed();
    public Vec3fkeyframed targetAdd = new Vec3fkeyframed();
    public float addMul = 1.0f;
    float rollx = 0.0f;
    float rolly = 0.0f;
    float rollz = 1.0f;
    public boolean projecttimer = false;
    public float myfov = -1.0f;
    FloatBuffer mfb = BufferUtils.createFloatBuffer(16);
    float[] mCameraInverse = new float[16];
    float[] m = new float[16];

    public Camera() {
        this.setEnabled(false);
        this.type = 3;
        this.setOrder(5);
    }

    public void gluLookAt(float time) {
        if (this.projecttimer) {
            time = Project.getProject().getTime();
        }
        if ((double)this.roll != 0.0) {
            this.rollx = (float)Math.sin(-this.roll * 0.05f);
            this.rolly = 0.0f;
            this.rollz = (float)Math.cos(-this.roll * 0.05f);
        } else {
            this.rollx = 0.0f;
            this.rolly = 0.0f;
            this.rollz = 1.0f;
        }
        if (this.eyeAdd != null && this.targetAdd != null) {
            GLU.gluLookAt(this.eye.x.getValue(time) + this.eyeAdd.x.getValue() * this.addMul, this.eye.y.getValue(time) + this.eyeAdd.y.getValue() * this.addMul, this.eye.z.getValue(time) + this.eyeAdd.z.getValue() * this.addMul, this.target.x.getValue(time) + this.targetAdd.x.getValue() * this.addMul, this.target.y.getValue(time) + this.targetAdd.y.getValue() * this.addMul, this.target.z.getValue(time) + this.targetAdd.z.getValue() * this.addMul, this.rollx, this.rolly, this.rollz);
        } else {
            GLU.gluLookAt(this.eye.x.getValue(time), this.eye.y.getValue(time), this.eye.z.getValue(time), this.target.x.getValue(time), this.target.y.getValue(time), this.target.z.getValue(time), this.rollx, this.rolly, this.rollz);
        }
    }

    public void render(float time) {
        if (!this.enabled) {
            return;
        }
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        float f = this.fov;
        if (this.myfov != -1.0f) {
            f = this.myfov;
        }
        GLU.gluPerspective(f, 1.7777778f, this.znear, this.zfar);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.gluLookAt(time);
    }

    public FloatBuffer getInverseMatrix(float time) {
        GL11.glGetFloat(2982, this.mfb);
        this.mfb.get(this.m);
        this.mCameraInverse[0] = this.m[0];
        this.mCameraInverse[1] = this.m[4];
        this.mCameraInverse[2] = this.m[8];
        this.mCameraInverse[4] = this.m[1];
        this.mCameraInverse[5] = this.m[5];
        this.mCameraInverse[6] = this.m[9];
        this.mCameraInverse[8] = this.m[2];
        this.mCameraInverse[9] = this.m[6];
        this.mCameraInverse[10] = this.m[10];
        this.mCameraInverse[3] = 0.0f;
        this.mCameraInverse[7] = 0.0f;
        this.mCameraInverse[11] = 0.0f;
        this.mCameraInverse[15] = 1.0f;
        this.mCameraInverse[12] = -(this.m[12] * this.m[0]) - this.m[13] * this.m[1] - this.m[14] * this.m[2];
        this.mCameraInverse[13] = -(this.m[12] * this.m[4]) - this.m[13] * this.m[5] - this.m[14] * this.m[6];
        this.mCameraInverse[14] = -(this.m[12] * this.m[8]) - this.m[13] * this.m[9] - this.m[14] * this.m[10];
        this.mfb.rewind();
        this.mfb.put(this.mCameraInverse).rewind();
        return this.mfb;
    }
}

