/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sumo.v3d.NodeIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements NodeIF {
    public boolean isSorted = false;
    public int order = 0;
    public int type = 0;
    public boolean enabled = true;
    public String name = "no name";
    public List<NodeIF> childs = new ArrayList<NodeIF>();

    public void addChild(NodeIF c) {
        this.childs.add(c);
    }

    @Override
    public void setOrder(int o) {
        this.order = o;
    }

    @Override
    public void render(float time) {
        if (!this.isSorted) {
            this.sortChilds();
        }
        this.renderChilds(time);
    }

    @Override
    public void renderChilds(float time) {
        if (!this.isSorted) {
            this.sortChilds();
        }
        for (NodeIF n : this.childs) {
            if (!n.getEnabled()) continue;
            n.render(time);
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void sortChilds() {
        System.out.println("sort childs...");
        Collections.sort(this.childs, new Comparator(){

            public int compare(Object a, Object b) {
                NodeIF ia = (NodeIF)a;
                NodeIF ib = (NodeIF)b;
                if (ia.getOrder() > ib.getOrder()) {
                    return 1;
                }
                return 0;
            }
        });
        this.isSorted = true;
    }

    @Override
    public int getNodeType() {
        return this.type;
    }

    public List<NodeIF> getChilds(int ctype) {
        ArrayList<NodeIF> ret = new ArrayList<NodeIF>();
        for (NodeIF n : this.childs) {
            if (n.getNodeType() != ctype) continue;
            ret.add(n);
        }
        return ret;
    }

    public int getNumChilds(int ctype) {
        int count = 0;
        for (NodeIF n : this.childs) {
            if (n.getNodeType() != ctype) continue;
            ++count;
        }
        return count;
    }

    public void disableChildsByType(int t) {
        for (int i = 0; i < this.childs.size(); ++i) {
            if (this.childs.get(i).getNodeType() != t) continue;
            this.childs.get(i).setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

