/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import org.lwjgl.opengl.GL11;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.Object;

public class BoundingBoxAA {
    float maxx = -1.0E9f;
    float maxy = -1.0E9f;
    float maxz = -1.0E9f;
    float miny = 9.999999E7f;
    float minx = 9.999999E7f;
    float minz = 1.0E8f;
    String name = "";

    public String getName() {
        return this.name;
    }

    public void calc(Object obj) {
        this.calc(obj, true);
    }

    public void calc(Object obj, boolean absolute) {
        this.name = obj.getName();
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        if (absolute) {
            px = obj.pos.x;
            py = obj.pos.y;
            pz = obj.pos.z;
        }
        for (Mesh mesh : obj.meshes) {
            if (mesh.vertices.length == 0) {
                return;
            }
            for (int i = 0; i < mesh.vertices.length; ++i) {
                if (mesh.vertices[i].x * obj.scale.x + px > this.maxx) {
                    this.maxx = mesh.vertices[i].x * obj.scale.x + px;
                }
                if (mesh.vertices[i].y * obj.scale.y + py > this.maxy) {
                    this.maxy = mesh.vertices[i].y * obj.scale.y + py;
                }
                if (mesh.vertices[i].z * obj.scale.z + pz > this.maxz) {
                    this.maxz = mesh.vertices[i].z * obj.scale.z + pz;
                }
                if (mesh.vertices[i].x * obj.scale.x + px < this.minx) {
                    this.minx = mesh.vertices[i].x * obj.scale.x + px;
                }
                if (mesh.vertices[i].y * obj.scale.y + py < this.miny) {
                    this.miny = mesh.vertices[i].y * obj.scale.y + py;
                }
                if (!(mesh.vertices[i].z * obj.scale.z + pz < this.minz)) continue;
                this.minz = mesh.vertices[i].z * obj.scale.z + pz;
            }
        }
    }

    public void render(float w) {
        GL11.glPointSize(10.0f);
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glLineWidth(w);
        GL11.glBegin(3);
        GL11.glVertex3f(this.maxx, this.maxy, this.maxz);
        GL11.glVertex3f(this.minx, this.maxy, this.maxz);
        GL11.glVertex3f(this.minx, this.miny, this.maxz);
        GL11.glVertex3f(this.maxx, this.miny, this.maxz);
        GL11.glVertex3f(this.maxx, this.maxy, this.maxz);
        GL11.glEnd();
        GL11.glBegin(3);
        GL11.glVertex3f(this.maxx, this.maxy, this.minz);
        GL11.glVertex3f(this.minx, this.maxy, this.minz);
        GL11.glVertex3f(this.minx, this.miny, this.minz);
        GL11.glVertex3f(this.maxx, this.miny, this.minz);
        GL11.glVertex3f(this.maxx, this.maxy, this.minz);
        GL11.glEnd();
        GL11.glBegin(1);
        GL11.glVertex3f(this.maxx, this.maxy, this.minz);
        GL11.glVertex3f(this.maxx, this.maxy, this.maxz);
        GL11.glVertex3f(this.maxx, this.miny, this.minz);
        GL11.glVertex3f(this.maxx, this.miny, this.maxz);
        GL11.glVertex3f(this.minx, this.maxy, this.minz);
        GL11.glVertex3f(this.minx, this.maxy, this.maxz);
        GL11.glVertex3f(this.minx, this.miny, this.minz);
        GL11.glVertex3f(this.minx, this.miny, this.maxz);
        GL11.glEnd();
    }

    public boolean collisiontestXYZ(VEC3Tweened pos) {
        return pos.x.getValue() > this.minx && pos.x.getValue() < this.maxx && pos.y.getValue() > this.miny && pos.y.getValue() < this.maxy && pos.z.getValue() > this.minz && pos.z.getValue() < this.maxz;
    }

    public boolean collisiontestXY(VEC3Tweened pos) {
        return pos.x.getValue() > this.minx && pos.x.getValue() < this.maxx && pos.y.getValue() > this.miny && pos.y.getValue() < this.maxy;
    }

    public float getMaxZ() {
        return this.maxz;
    }

    public String toString() {
        return this.minx + "," + this.miny;
    }
}

