/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.simpleview;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class v3dsimpleview
extends JFrame {
    public static JTable table;
    static int VSTATIC_CHUNK_FLOAT;
    static int VSTATIC_CHUNK_INT;
    static int VSTATIC_CHUNK_STRING;
    static int VSTATIC_CHUNK_EMPTY;
    static int VSTATIC_CHUNK_BYTE;
    static int VSTATIC_CHUNK_SHORT;
    String[] columnNames = new String[]{"id", "chunkid", "type", "size", "num", "content"};
    Object[][] data = new Object[][]{{"", "", ""}};
    static JScrollPane scroll;
    static String filename;
    static DefaultTableModel model;
    static JButton but;
    static JButton loadbut;
    static JTextField search;
    String title = "v3d simpleview ";
    static String[] chunkIDtypes;
    static String[] chunktypes;
    static byte[] arr;
    static BufferedInputStream in;
    static int searchfound;

    public v3dsimpleview() {
        v3dsimpleview.buildChunkTypeArray();
        this.setLayout(null);
        model = new DefaultTableModel(this.data, this.columnNames);
        table = new JTable(model);
        table.setFillsViewportHeight(true);
        table.getColumn("id").setPreferredWidth(5);
        table.getColumn("chunkid").setPreferredWidth(80);
        table.getColumn("type").setPreferredWidth(40);
        table.getColumn("size").setPreferredWidth(5);
        table.getColumn("num").setPreferredWidth(5);
        table.getColumn("content").setPreferredWidth(500);
        table.setPreferredScrollableViewportSize(new Dimension(200, 200));
        this.setTitle(this.title + filename);
        scroll = new JScrollPane(table);
        scroll.setBounds(0, 0, 790, 430);
        scroll.setBorder(null);
        this.add(scroll);
        but = new JButton("reload");
        but.setPreferredSize(new Dimension(20, 100));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                but.setEnabled(false);
                loadbut.setEnabled(false);
                table.setEnabled(false);
                v3dsimpleview.this.setTitle("v3d simple viewer " + filename);
                while (model.getRowCount() > 0) {
                    model.removeRow(0);
                }
                v3dsimpleview.readV3D();
                but.setEnabled(true);
                loadbut.setEnabled(true);
                table.setEnabled(true);
                table.updateUI();
            }
        });
        this.add(but);
        loadbut = new JButton("open...");
        loadbut.setPreferredSize(new Dimension(20, 100));
        loadbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                v3dsimpleview.this.setTitle(v3dsimpleview.this.title + "loading...... ");
                but.setEnabled(false);
                loadbut.setEnabled(false);
                table.setEnabled(false);
                while (model.getRowCount() > 0) {
                    model.removeRow(0);
                }
                FileDialog fd = new FileDialog((Frame)new JFrame(), "load...", 0);
                fd.show();
                if (fd.getDirectory() != null || fd.getFile() != null) {
                    filename = fd.getDirectory() + fd.getFile();
                }
                fd.dispose();
                but.setEnabled(true);
                loadbut.setEnabled(true);
                table.setEnabled(true);
                v3dsimpleview.readV3D();
                v3dsimpleview.this.setTitle(v3dsimpleview.this.title + "" + filename);
            }
        });
        loadbut.setPreferredSize(new Dimension(20, 100));
        this.add(loadbut);
        search = new JTextField();
        search.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                v3dsimpleview.search();
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.add(search);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                v3dsimpleview.makeScale();
            }
        });
        but.setBounds(10, 440, 80, 20);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        search.requestFocus();
        v3dsimpleview.makeScale();
    }

    public static void makeScale() {
        System.out.println("resize");
        scroll.setBounds(0, 0, v3dsimpleview.getFrames()[0].getBounds().width - 6, v3dsimpleview.getFrames()[0].getBounds().height - 70);
        scroll.updateUI();
        but.setBounds(10, v3dsimpleview.getFrames()[0].getBounds().height - 63, 80, 20);
        loadbut.setBounds(110, v3dsimpleview.getFrames()[0].getBounds().height - 63, 80, 20);
        search.setBounds(210, v3dsimpleview.getFrames()[0].getBounds().height - 63, 180, 20);
        but.updateUI();
    }

    static void buildChunkTypeArray() {
        v3dsimpleview.chunkIDtypes[1] = "v3d version";
        v3dsimpleview.chunkIDtypes[5] = "background color";
        v3dsimpleview.chunkIDtypes[10] = "animation fps";
        v3dsimpleview.chunkIDtypes[11] = "samplerate mesh";
        v3dsimpleview.chunkIDtypes[12] = "samplerate anim";
        v3dsimpleview.chunkIDtypes[13] = "anim length";
        v3dsimpleview.chunkIDtypes[200] = "<html><b color='#0099ff'>MESHOBJECT</b></html>";
        v3dsimpleview.chunkIDtypes[201] = "name";
        v3dsimpleview.chunkIDtypes[202] = "pos";
        v3dsimpleview.chunkIDtypes[203] = "rotation";
        v3dsimpleview.chunkIDtypes[204] = "scale";
        v3dsimpleview.chunkIDtypes[205] = "numvertices";
        v3dsimpleview.chunkIDtypes[206] = "numfaces";
        v3dsimpleview.chunkIDtypes[215] = "wirecolor";
        v3dsimpleview.chunkIDtypes[216] = "normals";
        v3dsimpleview.chunkIDtypes[217] = "pos anim";
        v3dsimpleview.chunkIDtypes[218] = "roation anim";
        v3dsimpleview.chunkIDtypes[219] = "visibility track";
        v3dsimpleview.chunkIDtypes[220] = "user property";
        v3dsimpleview.chunkIDtypes[221] = "user property value";
        v3dsimpleview.chunkIDtypes[299] = "object ende";
        v3dsimpleview.chunkIDtypes[301] = "mesh vertices";
        v3dsimpleview.chunkIDtypes[302] = "faces";
        v3dsimpleview.chunkIDtypes[303] = "material";
        v3dsimpleview.chunkIDtypes[304] = "texture channel";
        v3dsimpleview.chunkIDtypes[305] = "texturecoords";
        v3dsimpleview.chunkIDtypes[306] = "texture faces";
        v3dsimpleview.chunkIDtypes[350] = "mesh end";
        v3dsimpleview.chunkIDtypes[400] = "<html><b color='#0099ff'>CAMERA</b></html>";
        v3dsimpleview.chunkIDtypes[401] = "pos";
        v3dsimpleview.chunkIDtypes[402] = "target";
        v3dsimpleview.chunkIDtypes[403] = "name";
        v3dsimpleview.chunkIDtypes[404] = "rotation";
        v3dsimpleview.chunkIDtypes[405] = "fov";
        v3dsimpleview.chunkIDtypes[407] = "target anim";
        v3dsimpleview.chunkIDtypes[408] = "pos anim";
        v3dsimpleview.chunkIDtypes[449] = "camera end";
        v3dsimpleview.chunkIDtypes[450] = "<html><b color='#0099ff'>LIGHT</b></html>";
        v3dsimpleview.chunkIDtypes[451] = "name";
        v3dsimpleview.chunkIDtypes[452] = "pos";
        v3dsimpleview.chunkIDtypes[453] = "color";
        v3dsimpleview.chunkIDtypes[454] = "multiplier";
        v3dsimpleview.chunkIDtypes[499] = "light end";
        v3dsimpleview.chunkIDtypes[600] = "<html><b color='#0099ff'>Material</b></html>";
        v3dsimpleview.chunkIDtypes[601] = "name";
        v3dsimpleview.chunkIDtypes[602] = "diffuse";
        v3dsimpleview.chunkIDtypes[603] = "ambient";
        v3dsimpleview.chunkIDtypes[604] = "specular";
        v3dsimpleview.chunkIDtypes[605] = "opacity";
        v3dsimpleview.chunkIDtypes[606] = "twosided";
        v3dsimpleview.chunkIDtypes[607] = "faceted";
        v3dsimpleview.chunkIDtypes[608] = "wired";
        v3dsimpleview.chunkIDtypes[609] = "specular level";
        v3dsimpleview.chunkIDtypes[610] = "glossiness";
        v3dsimpleview.chunkIDtypes[631] = "map ambient";
        v3dsimpleview.chunkIDtypes[632] = "map diffuse";
        v3dsimpleview.chunkIDtypes[633] = "map specular";
        v3dsimpleview.chunkIDtypes[634] = "map specularlevel";
        v3dsimpleview.chunkIDtypes[635] = "map glossiness";
        v3dsimpleview.chunkIDtypes[636] = "map selfillumination";
        v3dsimpleview.chunkIDtypes[637] = "map opacity";
        v3dsimpleview.chunkIDtypes[638] = "map filtercolor";
        v3dsimpleview.chunkIDtypes[639] = "map bump";
        v3dsimpleview.chunkIDtypes[640] = "map reflection";
        v3dsimpleview.chunkIDtypes[641] = "map refraction";
        v3dsimpleview.chunkIDtypes[642] = "map displacement";
        v3dsimpleview.chunkIDtypes[645] = "filename";
        v3dsimpleview.chunkIDtypes[660] = "map end";
        v3dsimpleview.chunkIDtypes[699] = "material end";
        v3dsimpleview.chunkIDtypes[9000] = "eof";
        v3dsimpleview.chunktypes[1] = "floats";
        v3dsimpleview.chunktypes[2] = "ints";
        v3dsimpleview.chunktypes[3] = "string";
        v3dsimpleview.chunktypes[4] = "empty";
        v3dsimpleview.chunktypes[5] = "bytes";
        v3dsimpleview.chunktypes[6] = "shorts";
    }

    static int readInt() {
        int accum = 0;
        try {
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                accum |= (v3dsimpleview.myReadByte() & 0xFF) << shiftBy;
            }
        }
        catch (Exception e) {
            System.out.println("binarystream error...");
            e.printStackTrace();
            System.exit(0);
        }
        return accum;
    }

    public static short readShort() {
        try {
            in.read(arr, 0, 2);
            int start = 0;
            int low = arr[start] & 0xFF;
            int high = arr[start + 1] & 0xFF;
            return (short)(high << 8 | low);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static byte myReadByte() {
        byte[] b = new byte[1];
        try {
            in.read(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return b[0];
    }

    public static void readV3D() {
        long starttime = System.currentTimeMillis();
        try {
            if (filename == null || filename == "") {
                return;
            }
            System.out.println("read:" + filename);
            FileInputStream fstream = new FileInputStream(filename);
            in = new BufferedInputStream(fstream);
            v3dsimpleview.myReadByte();
            v3dsimpleview.myReadByte();
            v3dsimpleview.myReadByte();
            v3dsimpleview.myReadByte();
            boolean cont = true;
            while (cont) {
                int i;
                int elements = -1;
                short chunkID = v3dsimpleview.readShort();
                byte chunkTYPE = v3dsimpleview.myReadByte();
                int size = v3dsimpleview.readInt();
                if (chunkID == 9000) {
                    cont = false;
                }
                String content = "";
                if (chunkTYPE == VSTATIC_CHUNK_FLOAT) {
                    elements = size / 4;
                    for (i = 0; i < elements; ++i) {
                        if (i < 100) {
                            content = content + v3dsimpleview.readFloatLittleEndian() + "  ";
                            continue;
                        }
                        v3dsimpleview.readFloatLittleEndian();
                    }
                }
                if (chunkTYPE == VSTATIC_CHUNK_INT) {
                    elements = size / 4;
                    for (i = 0; i < elements; ++i) {
                        if (i < 100) {
                            content = content + v3dsimpleview.readInt() + "  ";
                            continue;
                        }
                        v3dsimpleview.readInt();
                    }
                }
                if (chunkTYPE == VSTATIC_CHUNK_SHORT) {
                    elements = size / 2;
                    for (i = 0; i < elements; ++i) {
                        if (i < 100) {
                            content = content + v3dsimpleview.readShort() + "  ";
                            continue;
                        }
                        v3dsimpleview.readShort();
                    }
                }
                if (chunkTYPE == VSTATIC_CHUNK_STRING) {
                    elements = size - 1;
                    byte[] b = new byte[elements];
                    in.read(b, 0, elements);
                    content = "<html><b>" + new String(b) + "</b></html>";
                    v3dsimpleview.myReadByte();
                }
                if (chunkTYPE == VSTATIC_CHUNK_BYTE) {
                    elements = size;
                    for (int i2 = 0; i2 < elements; ++i2) {
                        byte v = v3dsimpleview.myReadByte();
                        content = content + v + "  ";
                    }
                }
                model.insertRow(table.getRowCount(), new Object[]{(int)chunkID, chunkIDtypes[chunkID], chunktypes[chunkTYPE], size, elements, content});
            }
            in.close();
            fstream.close();
            v3dsimpleview.search();
            float time = (float)(System.currentTimeMillis() - starttime) / 1000.0f;
            System.out.println(time + "s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        filename = "";
        if (args.length > 0) {
            filename = args[0];
        }
        new v3dsimpleview();
        v3dsimpleview.readV3D();
        System.out.println("finished...");
    }

    static int readIntLittleEndian(DataInputStream data_in) {
        int accum = 0;
        try {
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                accum |= (data_in.readByte() & 0xFF) << shiftBy;
            }
        }
        catch (Exception e) {
            System.out.println(" error...");
            e.printStackTrace();
            System.exit(0);
        }
        return accum;
    }

    public static int readShort(DataInputStream in) {
        try {
            byte[] arr = new byte[2];
            in.read(arr, 0, 2);
            int start = 0;
            int low = arr[start] & 0xFF;
            int high = arr[start + 1] & 0xFF;
            return high << 8 | low;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    static float readFloatLittleEndian() {
        int accum = 0;
        try {
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                accum |= (in.read() & 0xFF) << shiftBy;
            }
        }
        catch (Exception e) {
            System.out.println("error...");
            e.printStackTrace();
            System.exit(0);
        }
        return Float.intBitsToFloat(accum);
    }

    static void search() {
        int foundcount = 0;
        String marked = "<span style='color:#ffffff;background-color:#FF6600;'> &nbsp;";
        for (int r = 0; r < model.getRowCount(); ++r) {
            for (int c = 0; c < model.getColumnCount(); ++c) {
                Object o = model.getValueAt(r, c);
                if (o == null) continue;
                String s = o.toString();
                if (s.length() > 1 && s.toLowerCase().contains(search.getText().toLowerCase()) && search.getText().length() > 1) {
                    if (foundcount == searchfound) {
                        Rectangle re = table.getCellRect(r, c, true);
                        re.y -= 40;
                        re.height = (int)((double)scroll.getHeight() * 0.7);
                        table.scrollRectToVisible(re);
                    }
                    ++foundcount;
                    if ((s = s.replace("<html>" + marked, "<html>")).contains("<html>")) {
                        model.setValueAt(s.replace("<html>", "<html>" + marked), r, c);
                        continue;
                    }
                    model.setValueAt("<html>" + marked + s, r, c);
                    continue;
                }
                if (!s.contains("<html>" + marked)) continue;
                s = s.replace("<html>" + marked, "<html>");
                model.setValueAt(s, r, c);
            }
        }
    }

    public void setFilename(String string) {
        filename = string;
    }

    static {
        VSTATIC_CHUNK_FLOAT = 1;
        VSTATIC_CHUNK_INT = 2;
        VSTATIC_CHUNK_STRING = 3;
        VSTATIC_CHUNK_EMPTY = 4;
        VSTATIC_CHUNK_BYTE = 5;
        VSTATIC_CHUNK_SHORT = 6;
        filename = "";
        chunkIDtypes = new String[9001];
        chunktypes = new String[256];
        arr = new byte[2];
        searchfound = 0;
    }
}

