varying vec3 normal, lightDir, eyeVec;
uniform float time;
uniform float deformv;


	vec4 DoTwist( vec4 pos, float t )
	{
		float st = sin(t);
		float ct = cos(t);
		vec4 new_pos;
		
		new_pos.x = pos.x*ct - pos.z*st;
		new_pos.z = pos.x*st + pos.z*ct;
		
		new_pos.y = pos.y;
		new_pos.w = pos.w;

		return( new_pos );
	}
	
	
void main()
{	
	normal = gl_NormalMatrix * gl_Normal;

	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);

	lightDir = vec3(gl_LightSource[1].position.xyz - vVertex);
	eyeVec = -vVertex;


	if(deformv!=0.0)
	{
		vec4 twistedPosition = gl_ModelViewProjectionMatrix*gl_Vertex;
	
		twistedPosition.x=(sin(twistedPosition.x+time*0.2))*deformv*25.0+twistedPosition.x;
		twistedPosition.z=(sin(twistedPosition.z+time*0.2))*deformv*25.0+twistedPosition.z;
		twistedPosition.y=(sin(twistedPosition.y+time*0.2))*deformv*25.0+twistedPosition.y;
	

//		twistedPosition.x=sin(twistedPosition.x*0.2+time*0.2)+twistedPosition.x;
//		twistedPosition.y=sin(twistedPosition.y*0.2+time*0.2)+twistedPosition.y;
//		twistedPosition.z=sin(twistedPosition.z*0.2+time*0.2)+twistedPosition.z;
		
		gl_Position =  twistedPosition;
	}
	else
			
		gl_Position = ftransform();	
}


