typedef unsigned int   word;
typedef unsigned char  byte;
typedef unsigned long dword;
struct Color {unsigned char r, g, b;};
Color CurPal[256],NewPal[256];
extern int chkflg;
extern word ytab[200];
/*..................... Standart 10h function to set 1 color RGB ...........*/
void SetRGBColor(byte col,byte r,byte g,byte b)
{
  asm{
      mov   dx, 0x3c8
      mov   al, [col]
      out   dx, al
      inc   dx
      mov   al, [r]
      out   dx, al
      mov   al, [g]
      out   dx, al
      mov   al, [b]
      out   dx, al
     }
}
/*.......................... Set Full palette at onece .....................*/
void SetPal()
{for(int i=0;i<256;i++)SetRGBColor(i,NewPal[i].r,NewPal[i].g,NewPal[i].b);}
/*....................... Pre Generate on of 6 palettes ....................*/
void PalGenerator(int mode)
{
int i,j;
if(mode==-1) mode=rand()%6;
  for(i=0,j=1;i<256;i+=4,j++)
      switch(mode)
	{
	case 0:
	  NewPal[i].r   = j;
	  NewPal[i+1].r = j;
	  NewPal[i+2].r = j;
	  NewPal[i+3].r = j;
	  NewPal[i].g   = 0;
	  NewPal[i+1].g = 0;
	  NewPal[i+2].g = 0;
	  NewPal[i+3].g = 0;
	  NewPal[i].b   = 0;
	  NewPal[i+1].b = 0;
	  NewPal[i+2].b = 0;
	  NewPal[i+3].b = 0;
	break;
	case 1:
	  NewPal[i].r   = 0;
	  NewPal[i+1].r = 0;
	  NewPal[i+2].r = 0;
	  NewPal[i+3].r = 0;
	  NewPal[i].g   = j;
	  NewPal[i+1].g = j;
	  NewPal[i+2].g = j;
	  NewPal[i+3].g = j;
	  NewPal[i].b   = 0;
	  NewPal[i+1].b = 0;
	  NewPal[i+2].b = 0;
	  NewPal[i+3].b = 0;
	break;
	case 2:
	  NewPal[i].r   = 0;
	  NewPal[i+1].r = 0;
	  NewPal[i+2].r = 0;
	  NewPal[i+3].r = 0;
	  NewPal[i].g   = 0;
	  NewPal[i+1].g = 0;
	  NewPal[i+2].g = 0;
	  NewPal[i+3].g = 0;
	  NewPal[i].b   = j;
	  NewPal[i+1].b = j;
	  NewPal[i+2].b = j;
	  NewPal[i+3].b = j;
	break;
	case 3:
	  NewPal[i].r   = j;
	  NewPal[i+1].r = j;
	  NewPal[i+2].r = j;
	  NewPal[i+3].r = j;
	  NewPal[i].g   = 0;
	  NewPal[i+1].g = 0;
	  NewPal[i+2].g = 0;
	  NewPal[i+3].g = 0;
	  NewPal[i].b   = j;
	  NewPal[i+1].b = j;
	  NewPal[i+2].b = j;
	  NewPal[i+3].b = j;
	  break;
	case 4:
	  NewPal[i].r   = j;
	  NewPal[i+1].r = j;
	  NewPal[i+2].r = j;
	  NewPal[i+3].r = j;
	  NewPal[i].g   = j;
	  NewPal[i+1].g = j;
	  NewPal[i+2].g = j;
	  NewPal[i+3].g = j;
	  NewPal[i].b   = 0;
	  NewPal[i+1].b = 0;
	  NewPal[i+2].b = 0;
	  NewPal[i+3].b = 0;
	  break;
	case 5:
	  NewPal[i].r   = 0;
	  NewPal[i+1].r = 0;
	  NewPal[i+2].r = 0;
	  NewPal[i+3].r = 0;
	  NewPal[i].g   = j;
	  NewPal[i+1].g = j;
	  NewPal[i+2].g = j;
	  NewPal[i+3].g = j;
	  NewPal[i].b   = j;
	  NewPal[i+1].b = j;
	  NewPal[i+2].b = j;
	  NewPal[i+3].b = j;
	  break;
	}
}
/*........................... Change Current Pallete to new ................*/
void ChangePal()
{
  for(int i=0;i<256;i++)
  {
    if(CurPal[i].r<NewPal[i].r)
       SetRGBColor(i,++CurPal[i].r,CurPal[i].g,CurPal[i].b);
    if(CurPal[i].r>NewPal[i].r)
       SetRGBColor(i,--CurPal[i].r,CurPal[i].g,CurPal[i].b);
    if(CurPal[i].g<NewPal[i].g)
       SetRGBColor(i,CurPal[i].r,++CurPal[i].g,CurPal[i].b);
    if(CurPal[i].g>NewPal[i].g)
       SetRGBColor(i,CurPal[i].r,--CurPal[i].g,CurPal[i].b);
    if(CurPal[i].b<NewPal[i].b)
       SetRGBColor(i,CurPal[i].r,CurPal[i].g,++CurPal[i].b);
    if(CurPal[i].b>NewPal[i].b)
       SetRGBColor(i,CurPal[i].r,CurPal[i].g,--CurPal[i].b);
    if(CurPal[i].r==NewPal[i].r&&CurPal[i].g==NewPal[i].g&&CurPal[i].b==NewPal[i].b)
      chkflg = 0;
    else
      chkflg = 1;
  }
}
/*................... Generate Dark Pallete ................................*/
void dark()
{
for(int i=0;i<256;i++)
  {
    NewPal[i].r=0;
    NewPal[i].g=0;
    NewPal[i].b=0;
  }
}
/*.................... Blur Effect .........................................*/
void Blur(byte *tmp)
{
int i,j;
for(i=1;i<199;i++)
for(j=1;j<320;j++)
    tmp[ytab[i]+j]=(tmp[ytab[i]+j+1]+tmp[ytab[i+1]+j]+tmp[ytab[i]+j-1]+tmp[ytab[i-1]+j])/4;
}
