//depth of field
uniform float focalDistance, focalRange;
varying float Blur;
varying float Depth;
//lighting
varying vec4 in_diffuse,in_ambientGlobal,in_ambient;
varying vec3 in_normal,in_lightDir,in_halfVector;
varying float in_dist;
//normalMapping
varying vec3 lightVec; 
varying vec3 eyeVec;
varying vec2 texCoord;



void main(void) {
	vec4 ecPos;
	vec3 aux;


	//calc vTangent
	vec3 c1,c2,vTangent;
	c1 = cross(gl_Normal,vec3(0.0,0.0,1.0));
	c2 = cross(gl_Normal,vec3(1.0,0.0,0.0));
	if(length(c1)>length(c2)) {
		vTangent = c1;
	} else {
		vTangent = c2;
	}

	vTangent = normalize(vTangent);





	in_normal = normalize(gl_NormalMatrix * gl_Normal);
		
		/* these are the new lines of code to compute the light's direction */
	ecPos = gl_ModelViewMatrix * gl_Vertex;
	aux = vec3(gl_LightSource[0].position-ecPos);
	in_lightDir = normalize(aux);
	in_dist = length(aux);
	
	in_halfVector = normalize(gl_LightSource[0].halfVector.xyz);
		
	/* Compute the diffuse, ambient and globalAmbient terms */
	in_diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
		
	/* The ambient terms have been separated since one of them */
	/* suffers attenuation */
	in_ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	in_ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;



	//BUMPMAPPING
	vec3 t,n,b;
	vec3 tmpVec,vVertex;

	n = in_normal;
	t = normalize(gl_NormalMatrix * vTangent);
	b = cross(n,t);	
	
	
	lightVec.x = dot(aux, t);
	lightVec.y = dot(aux, b);
	lightVec.z = dot(aux, n);
	
	aux = -ecPos.xyz;
	eyeVec.x = dot(aux, t);
	eyeVec.y = dot(aux, b);
	eyeVec.z = dot(aux, n);
	
	//ending
	gl_FrontColor = gl_Color;
	Blur = clamp(abs(-ecPos.z - focalDistance) / focalRange, 0.0, 1.0);
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	Depth = 50.0/gl_Position.z;
}
