/*
 * Decompiled with CFR 0.152.
 */
package sumo.app.headlesscompose;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import sumo.gui.dialogs.exceptionDialog;
import sumo.opengl.OpenGLSettings;
import sumo.opengl.common;
import sumo.project.Project;
import sumo.project.ProjectFile;
import sumo.resource.ResourceManager;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.shader.ShaderPartProgram;
import sumo.util.FPSCounter;
import sumo.util.stopwatch;
import sumo.v3d.material.Material;

public class headlestest {
    static Pbuffer bla;

    public static void main(String[] args) {
        Material m;
        stopwatch watch = new stopwatch("headlessrendering");
        if (args.length < 2) {
            System.out.println("usage:");
            System.out.println(" headlessrenderer [SUMO XML FILE] [PNG OUTPUT FILE] [OPTIONAL: MATERIAL 1 IMAGE] [OPTIONAL: MATERIAL 2 IMAGE]");
            System.exit(1);
        }
        String filename = args[0];
        String outputfilename = args[1];
        Project.headless = true;
        Project p = new Project();
        Project.guimode = false;
        p.init();
        ShaderPartProgram.watchshaders = false;
        ResourceManager.useRelativePath = true;
        Project.setProject(p);
        OpenGLSettings settings = new OpenGLSettings();
        settings.setWidth(1920);
        settings.setHeight(1080);
        settings.setMultisampling(8);
        p.setOpenGLSsettings(settings);
        try {
            stopwatch s = new stopwatch("pbuffer init");
            bla = new Pbuffer(settings.getWidth(), settings.getHeight(), new PixelFormat(8, 8, 8), null);
            bla.makeCurrent();
            s.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Display.isCreated()) {
            Display.processMessages();
            try {
                Display.swapBuffers();
                Display.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ProjectFile.load(p, filename);
        while (Project.getProject().getResourceManager().loadingBar()) {
        }
        v3d v = (v3d)Project.getProject().getResourceManager().getResourceByFileName("model.v3d");
        if (args.length > 2) {
            Project.getProject().getResourceManager().add("", args[2]);
            while (Project.getProject().getResourceManager().loadingBar()) {
            }
            m = v.getScene().getMaterialByTitle("mat1_flat");
            if (m == null) {
                System.out.println("material 1 null!");
            } else {
                m.settings.mapDiffuse.texture = (textureFile)Project.getProject().getResourceManager().getResourceByFileName(args[2]);
            }
        }
        if (args.length > 3) {
            Project.getProject().getResourceManager().add("", args[3]);
            while (Project.getProject().getResourceManager().loadingBar()) {
            }
            m = v.getScene().getMaterialByTitle("mat2_flat");
            if (m == null) {
                System.out.println("material 2 null!");
            } else {
                m.settings.mapDiffuse.texture = (textureFile)Project.getProject().getResourceManager().getResourceByFileName(args[3]);
            }
        }
        while (Project.getProject().getResourceManager().loadingBar()) {
        }
        GL11.glClearColor(1.0f, 1.0f, 0.0f, 1.0f);
        if (Display.isCreated()) {
            Display.processMessages();
            try {
                Display.swapBuffers();
                Display.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < Project.getProject().getNumScenes(); ++i) {
            GL11.glClear(16640);
        }
        boolean isPlaying = false;
        FPSCounter fps = new FPSCounter();
        fps.setOutput(false);
        try {
            int width = settings.getWidth() / 2;
            int height = settings.getHeight() / 2;
            Project.getProject().getScene(0).render();
            BufferedImage img = common.screenShot(settings.getWidth(), settings.getHeight());
            BufferedImage bdest = new BufferedImage(width, height, 1);
            Graphics2D g = bdest.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform at = AffineTransform.getScaleInstance(1.0, 1.0);
            g.drawImage(img.getScaledInstance(width, height, 16), at, null);
            ImageIO.write((RenderedImage)bdest, "PNG", new File(outputfilename));
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        watch.stop();
        System.exit(0);
    }
}

