/*
 * Decompiled with CFR 0.152.
 */
package sumo.app.loader;

import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import sumo.app.loader.LoadingBarIF;
import sumo.logger.Logger;
import sumo.opengl.common;
import sumo.project.Project;
import sumo.v3d.math.Vec3f;

public class LoadingCircle
implements LoadingBarIF {
    Vec3f[] points;
    Vec3f[] innerPoints;
    int numPoints = 36;
    float radius;
    float innerradius;
    public int loadingsteps;
    float lightcolorr = 0.5f;
    float lightcolorg = 0.5f;
    float lightcolorb = 0.5f;
    float percent = 0.0f;

    public LoadingCircle() {
        this.init(1.0f, 0.8f);
    }

    LoadingCircle(int r, int ir) {
        this.lightcolorr = 0.5f;
        this.lightcolorg = 0.5f;
        this.lightcolorb = 0.5f;
        this.init(r, ir);
    }

    private void init(float r, float ir) {
        float i;
        this.radius = r;
        this.innerradius = ir;
        this.points = new Vec3f[this.numPoints + 1];
        this.innerPoints = new Vec3f[this.numPoints + 1];
        float full = 6.3f;
        float step = full / (float)this.numPoints;
        int pointcounter = 0;
        for (i = 0.0f; i < full + step; i += step) {
            this.points[pointcounter] = new Vec3f();
            this.points[pointcounter].x = (float)Math.cos(i) * this.radius;
            this.points[pointcounter].y = (float)Math.sin(i) * this.radius;
            ++pointcounter;
        }
        pointcounter = 0;
        for (i = 0.0f; i < full + step; i += step) {
            this.innerPoints[pointcounter] = new Vec3f();
            this.innerPoints[pointcounter].x = (float)Math.cos(i) * this.innerradius;
            this.innerPoints[pointcounter].y = (float)Math.sin(i) * this.innerradius;
            ++pointcounter;
        }
    }

    private void pdraw(float perc) {
        GL11.glBegin(7);
        int i = 0;
        while ((float)i < (float)this.numPoints * perc) {
            GL11.glVertex3f(this.points[i].x, this.points[i].y, 0.0f);
            GL11.glVertex3f(this.points[i + 1].x, this.points[i + 1].y, 0.0f);
            GL11.glVertex3f(this.innerPoints[i + 1].x, this.innerPoints[i + 1].y, 0.0f);
            GL11.glVertex3f(this.innerPoints[i].x, this.innerPoints[i].y, 0.0f);
            ++i;
        }
        GL11.glEnd();
    }

    public void draw(float p) {
        if (Project.headless) {
            return;
        }
        GL11.glDisable(34037);
        GL11.glDisable(3042);
        GL11.glLoadIdentity();
        GL11.glClear(16640);
        GL11.glDisable(2896);
        GL11.glDisable(2929);
        GL11.glDisable(3553);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -30.0f);
        GL11.glRotatef(180.0f, 1.0f, 1.0f, 0.0f);
        GL11.glPushMatrix();
        GL11.glScalef(1.1f, 1.1f, 1.1f);
        GL11.glColor3f(0.15f, 0.15f, 0.15f);
        this.pdraw(1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef(0.9f, 0.9f, 0.9f);
        GL11.glColor3f(0.15f, 0.15f, 0.15f);
        this.pdraw(1.0f);
        GL11.glPopMatrix();
        GL11.glColor3f(0.0f, 0.0f, 0.0f);
        this.pdraw(1.0f);
        GL11.glColor3f(this.lightcolorr, this.lightcolorg, this.lightcolorb);
        this.pdraw(p);
        GL11.glEnable(2896);
        Display.update();
    }

    public void render(float f) {
        common.switchTo2d();
        common.switchTo3d();
        GL11.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        GL11.glClear(16640);
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.draw(f);
        if (Display.isCreated()) {
            Display.processMessages();
            try {
                Display.swapBuffers();
                Display.update();
            }
            catch (Exception e) {
                Logger.log(this.getClass(), e);
            }
        }
    }
}

