/*
 * Decompiled with CFR 0.152.
 */
package sumo.evoke.plugins.evokebeam.data;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import sumo.evoke.plugins.evokebeam.CompoResults;
import sumo.evoke.plugins.evokebeam.EvokeSettings;
import sumo.evoke.plugins.evokebeam.data.Overlay;
import sumo.evoke.plugins.evokebeam.data.Text;
import sumo.evoke.plugins.evokebeam.evokebeam;
import sumo.opengl.FBOManager;
import sumo.opengl.FullScreenRect;
import sumo.opengl.common;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumoTween.timer.freeTimer;

public class Screen {
    public static int randombg = 1;
    private ArrayList<Text> texte = new ArrayList();
    private ArrayList<Overlay> overlays = new ArrayList();
    private textureFile backgroundTexture = null;
    private int duration = 15000;
    public int type = 0;
    private CompoResults results = null;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SPONSOR = 1;
    public static final int TYPE_COMPORELEASE = 2;
    public static final int TYPE_LINEWAITSCREEN = 3;
    public static final int TYPE_JINGLE_LONG = 4;
    public static final int TYPE_JINGLE_SHORT = 5;
    float fadeouttime = 0.0f;
    public static float fadelength = 1000.0f;
    public static boolean darken = false;
    public static freeTimer darkenTimer = new freeTimer();
    public boolean finished = false;
    private static freeTimer timer = new freeTimer();

    private void setRandomBackground() {
        int oldrandombg = randombg;
        while (oldrandombg == randombg) {
            randombg = (int)((double)EvokeSettings.SCENES_BACKGROUND.length * Math.random());
        }
    }

    public void setType(int i) {
        this.type = i;
    }

    public int getType() {
        return this.type;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void addText(int x, int y, int maxwidth, int maxheight, String s, int r, int g, int b, boolean bold, int size) {
        Text t = new Text();
        t.size = size;
        t.setMaxHeight(maxheight);
        t.setMaxWidth(maxwidth);
        t.setX(x);
        t.setY(y);
        t.setText(s, r, g, b, bold);
        this.texte.add(t);
    }

    public textureFile getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(textureFile backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }

    public void fadeOut(float time) {
        this.fadeouttime = time;
    }

    public void render(float time) {
        float fade = 1.0f;
        if (time < 2000.0f) {
            fade = time / 2000.0f;
        }
        if (time > (float)this.duration - fadelength) {
            fade = ((float)this.duration - time) / fadelength;
        }
        fade = common.smoothStep(fade);
        FBOManager.glViewport();
        GL11.glLoadIdentity();
        GL11.glClear(256);
        if (!Project.guimode) {
            Project.getProject().setTime(Float.valueOf(timer.getTime()));
        }
        Project.getProject().getScene(EvokeSettings.SCENES_BACKGROUND[randombg]).render();
        if (!Project.guimode) {
            Project.getProject().setTime(Float.valueOf(timer.getTime()));
            if (timer.getTime() >= 15.0f) {
                timer.reset();
                this.setRandomBackground();
            }
            if (timer.getTime() > 14.0f) {
                common.switchTo2d();
                GL11.glEnable(3042);
                float ff = 1.0f + timer.getTime() - 15.0f;
                GL11.glColor4f(0.45490196f, 0.7647059f, 0.8235294f, common.smoothStep(ff));
                FullScreenRect.draw();
                common.switchTo3d();
            }
            if (timer.getTime() <= 1.0f) {
                GL11.glEnable(3042);
                GL11.glColor4f(0.45490196f, 0.7647059f, 0.8235294f, common.smoothStep(1.0f - timer.getTime()));
                common.switchTo2d();
                FullScreenRect.draw();
                common.switchTo3d();
            }
        }
        if (this.type == 2 && !darken && darkenTimer.getTime() < 0.8f) {
            common.switchTo2d();
            GL11.glEnable(3042);
            GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.8f - darkenTimer.getTime());
            FullScreenRect.draw();
            common.switchTo3d();
        }
        if (this.type == 2 && darken) {
            GL11.glClear(256);
            common.switchTo2d();
            GL11.glEnable(3042);
            float dark = 0.8f;
            if (darkenTimer.getTime() <= 0.8f) {
                dark = darkenTimer.getTime();
            }
            GL11.glColor4f(0.0f, 0.0f, 0.0f, dark);
            FullScreenRect.draw();
            common.switchTo3d();
        }
        if (this.type == 0) {
            Project.getProject().setTime(Float.valueOf(fade));
            GL11.glEnable(2929);
            GL11.glLoadIdentity();
            GL11.glClear(256);
            Project.getProject().getScene(3).render();
            GL11.glDisable(2929);
            GL11.glClear(256);
        }
        if (this.type == 3) {
            if (!Project.guimode) {
                Project.getProject().setTime(Float.valueOf(fade));
            }
            Project.getProject().getScene(2).render();
        }
        if (this.type == 2) {
            Project.getProject().setTime(Float.valueOf(fade));
            Project.getProject().getScene(4).render();
        }
        GL11.glLoadIdentity();
        GL11.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glClear(256);
        GL11.glDisable(2929);
        common.switchTo2dd();
        if (this.backgroundTexture != null) {
            Screen.renderFullscreen(this.backgroundTexture, false, fade);
        }
        for (Overlay o : this.overlays) {
            o.draw(fade);
        }
        for (Text t : this.texte) {
            t.draw(fade);
        }
        if (this.results != null) {
            this.results.draw();
        }
        common.switchTo3d();
    }

    public static void renderFullscreen(textureFile t, boolean flip, float fade) {
        if (t == null) {
            System.out.println("texture null!!!!!");
            return;
        }
        boolean scale = false;
        float stn = 1.7777778f;
        if ((float)t.width / (float)t.height != stn) {
            scale = true;
        }
        t.enable();
        t.bind();
        int h = evokebeam.res.getY();
        int w = evokebeam.res.getX();
        int x = 0;
        if (scale) {
            int nh = 0;
            int nw = 0;
            nh = h;
            if (t.height < h) {
                nw = (int)((float)h / (float)t.height) * t.width;
            } else {
                nw = w;
                nh = h;
            }
            h = nh;
            w = nw;
            x = (evokebeam.res.getX() - nw) / 2;
        }
        int y1 = h;
        int y2 = 0;
        if (flip) {
            y1 = 0;
            y2 = h;
        }
        GL11.glEnable(3042);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, fade);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(x, y1);
        GL11.glTexCoord2f(0.0f, 1.0f * (float)t.height);
        GL11.glVertex2f(x, y2);
        GL11.glTexCoord2f(1.0f * (float)t.width, 1.0f * (float)t.height);
        GL11.glVertex2f(w + x, y2);
        GL11.glTexCoord2f(1.0f * (float)t.width, 0.0f);
        GL11.glVertex2f(w + x, y1);
        GL11.glEnd();
    }

    public CompoResults getResults() {
        return this.results;
    }

    public void setResults(CompoResults results) {
        this.results = results;
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public Text getText(int i) {
        return this.texte.get(i);
    }
}

