/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;

public class Button
extends JPanel {
    private boolean mouseOver = false;
    private boolean mousePressed = false;
    int icon = Icons.ICON_QUESTION;
    Color bgColor = Settings.SUMO2_BG;
    Color bgMouseOverColor = Settings.mainColor1;
    Color bgMousePressedColor = Settings.mainColor1a;
    private String tooltiptext;
    guiStopWatch watch = null;
    public boolean isActive = false;

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public Button(int i, String tooltip) {
        this.tooltiptext = tooltip;
        this.icon = i;
        this.init();
    }

    public Button() {
        this.init();
    }

    void init() {
        this.setToolTipText(this.tooltiptext);
        this.setBounds(new Rectangle(15, 15));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                Button.this.mouseOver = true;
                Button.this.setCursor(Cursor.getPredefinedCursor(12));
                Button.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                Button.this.mouseOver = false;
                Button.this.setCursor(Cursor.getPredefinedCursor(0));
                Button.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                Button.this.mousePressed = true;
                Button.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                Button.this.mousePressed = false;
                Button.this.repaint();
            }
        });
    }

    public void setIcon(int i) {
        this.icon = i;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_BUTTON);
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(this.bgColor);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isActive) {
            gd.setColor(Settings.mainColor1);
            gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.mouseOver) {
            if (this.mousePressed) {
                gd.setColor(this.bgMousePressedColor);
            } else {
                gd.setColor(this.bgMouseOverColor);
            }
            gd.fillRect(0, 0, this.getWidth(), this.getHeight());
            Icons.drawIcon(g, this.icon, 0, 0);
        } else {
            Icons.drawIcon(g, this.icon, 0, 0);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public void setPosition(int x, int y) {
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void setBgMouseOverColor(Color bg) {
        this.bgMouseOverColor = bg;
    }

    public void setBgMousePressedColor(Color bg) {
        this.bgMousePressedColor = bg;
    }

    public int getIcon() {
        return this.icon;
    }
}

