/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.SelectLists;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import sumo.gui.Settings;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.dialogs.selector.SelectorItem;
import sumo.gui.sumoComponents.list.ListLine;
import sumo.gui.sumoComponents.list.SumoList;
import sumo.plugin.PluginConfig;
import sumo.project.Project;

public class PluginSelect
extends DetailEmpty
implements DetailIF {
    SumoList mylist;

    public void dispose() {
    }

    public PluginSelect() {
        this.setSize(300, 300);
        this.setLayout(null);
        this.setBackground(Settings.SUMO2_BG);
        this.mylist = new SumoList();
        this.mylist.setBounds(0, 0, this.getWidth() - 40, 400);
        this.mylist.setPreferredSize(new Dimension(500, 500));
        this.rebuild();
        JScrollPane scrollList = new JScrollPane();
        scrollList = new JScrollPane(this.mylist);
        scrollList.getViewport().setBackground(Settings.SUMO2_BG);
        scrollList.setBorder(BorderFactory.createLineBorder(Settings.lineBackground, 0));
        scrollList.setBounds(10, 10, this.getWidth() - 20, this.getHeight() - 20);
        scrollList.getHorizontalScrollBar().setVisible(false);
        this.add(scrollList);
    }

    public void rebuild() {
        this.mylist.getRoot().removeChilds();
        String lastTypeDesc = "";
        ArrayList<SelectorItem> items = new ArrayList<SelectorItem>();
        ArrayList<PluginConfig> plugcfgs = Project.getProject().getPluginManager().getPluginsConfigs();
        for (int i = 0; i < plugcfgs.size(); ++i) {
            SelectorItem item = new SelectorItem();
            item.setTitle(plugcfgs.get(i).getName());
            item.setDescr(plugcfgs.get(i).getClassName());
            item.setObj(plugcfgs.get(i).getClassName());
            item.setIcon(plugcfgs.get(i).getIcon());
            item.setCategory(plugcfgs.get(i).getCategory());
            items.add(item);
        }
        for (SelectorItem item : items) {
            ListLine l = this.mylist.createLine(item.getTitle());
            l.setDNDString("plugin:" + (String)item.getObj());
            l.setSelectable(true);
            l.setIcon(item.getIcon());
            ListLine lcat = this.mylist.getChildByTitle(item.getCategory());
            if (lcat == null) {
                lcat = this.mylist.createLine(item.getCategory());
                this.mylist.getRoot().addChild(lcat);
            }
            lcat.addChild(l);
        }
        int height = this.mylist.reOrder();
        this.mylist.setBounds(0, 0, this.getWidth() - 40, height);
        this.mylist.setPreferredSize(new Dimension(this.getWidth() - 40, height));
    }
}

