/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.resources;

import sumo.gui.Icons;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.Elements.DetailLabel;
import sumo.project.Project;
import sumo.resource.types.textureFile;

public class TextureDetail
extends DetailEmpty
implements DetailIF {
    textureFile txresource;
    DetailButton reload;

    public void dispose() {
    }

    public TextureDetail(textureFile tx) {
        this.txresource = tx;
        this.setTitle(this, "texture: " + tx.getTitle());
        this.setSize(300, 300);
        this.setLayout(null);
        Area areaInfos = new Area("infos", this, Area.LAYOUT_ONE);
        DetailLabel l = new DetailLabel("size: " + tx.width + "x" + tx.height);
        areaInfos.addLine(l);
        DetailLabel l2 = new DetailLabel("filename: " + tx.getFilename());
        areaInfos.addLine(l2);
        DetailLabel l3 = new DetailLabel("path: " + tx.getPath());
        areaInfos.addLine(l3);
        DetailLabel l4 = new DetailLabel("glid: " + tx.id);
        areaInfos.addLine(l4);
        this.addArea(areaInfos);
        this.addResourceFunctions();
    }

    public void addResourceFunctions() {
        Area areaInfos = new Area("resource functions", this, Area.LAYOUT_ONE);
        DetailButton reload = new DetailButton(Icons.ICON_REFRESH, "reload");
        DetailButton remove = new DetailButton(Icons.ICON_TRASH, "remove");
        areaInfos.addLine(reload);
        areaInfos.addLine(remove);
        reload.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                TextureDetail.this.txresource.reload();
            }
        });
        remove.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                Project.getProject().getResourceManager().removeResourceWhenNotUsed(TextureDetail.this.txresource.getFilename());
            }
        });
        this.addArea(areaInfos);
    }
}

