/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.dialogs;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import sumo.logger.Logger;
import sumo.resource.types.sShader;

public class ShaderPanel
extends JPanel {
    JScrollPane scroll;
    JScrollPane scrollOutput;
    JList txtCompilerOutput;
    JTextPane txt;
    private int type = -1;
    sShader shader = null;
    String[] output;
    ArrayList<Integer> badlines = new ArrayList();
    static SimpleAttributeSet NORMAL = new SimpleAttributeSet();
    static SimpleAttributeSet COMMENT = new SimpleAttributeSet();
    static SimpleAttributeSet ERROR = new SimpleAttributeSet();

    public ShaderPanel(sShader _shader, int type) {
        this.setLayout(null);
        this.shader = _shader;
        this.type = type;
        this.scroll = new JScrollPane();
        this.scroll.setBorder(null);
        this.scroll.setBounds(0, 0, this.getWidth() - 10, 300);
        this.add(this.scroll);
        this.scrollOutput = new JScrollPane();
        this.add(this.scrollOutput);
        this.txtCompilerOutput = new JList();
        this.scrollOutput.setViewportView(this.txtCompilerOutput);
        this.txt = new JTextPane();
        this.txt.setEditable(false);
        this.scroll.setViewportView(this.txt);
        this.txtCompilerOutput.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String s = "";
                if (e.getFirstIndex() < ShaderPanel.this.output.length) {
                    s = ShaderPanel.this.output[e.getFirstIndex()];
                }
                if (s.startsWith("(")) {
                    ShaderPanel.this.badlines = new ArrayList();
                    int line = Integer.parseInt(s.substring(1).split("\\)")[0]);
                    ShaderPanel.this.badlines.add(line);
                    ShaderPanel.this.refresh();
                    ShaderPanel.this.txt.scrollRectToVisible(new Rectangle(0, (line - 1) * 20, 20, 20));
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ShaderPanel.this.updateResize();
            }
        });
    }

    public void refresh() {
        String t = this.type == 0 ? this.shader.getSumoShader().getFragmentCode() : this.shader.getSumoShader().getVertexCode();
        this.txt.setText("");
        String[] tx = t.split("\n");
        t = "";
        for (int i = 0; i < tx.length; ++i) {
            tx[i] = tx[i].replace("\r", "");
            tx[i] = tx[i].replace("\t\t\t\t\t", "\t");
            tx[i] = tx[i].replace("\t\t\t\t", "\t");
            tx[i] = tx[i].replace("\t\t\t", "\t");
            tx[i] = tx[i].replace("\t\t", "\t");
            String ln = i + 1 + "";
            for (int j = ln.length(); j < 5; ++j) {
                ln = ln + " ";
            }
            String finaltxt = ln + "" + tx[i];
            if (this.badlines.contains(Integer.valueOf(i) + 1)) {
                this.insertText(finaltxt, ERROR);
                continue;
            }
            if (tx[i].startsWith("//")) {
                this.insertText(finaltxt, COMMENT);
                continue;
            }
            this.insertText(finaltxt, NORMAL);
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        this.txtCompilerOutput.setModel(listModel);
        this.output = this.shader.getSumoShader().getCompilerOutput().split("\n");
        for (int i = 0; i < this.output.length; ++i) {
            listModel.addElement(this.output[i]);
        }
    }

    protected void insertText(String text, AttributeSet set) {
        try {
            this.txt.getDocument().insertString(this.txt.getDocument().getLength(), text + "\n", set);
        }
        catch (BadLocationException e) {
            Logger.log(this.getClass(), e);
        }
    }

    private void updateResize() {
        this.scroll.setBounds(0, 0, this.getWidth() - 10, this.getHeight() - 120);
        this.txt.setBounds(0, this.getHeight() - 100, this.getWidth() - 10, 100);
        this.scrollOutput.setBounds(0, this.getHeight() - 110, this.getWidth() - 10, 100);
    }

    static {
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontFamily(NORMAL, "Monospaced");
        StyleConstants.setFontSize(NORMAL, 12);
        StyleConstants.setForeground(ERROR, Color.red);
        StyleConstants.setFontFamily(ERROR, "Monospaced");
        StyleConstants.setFontSize(ERROR, 12);
        StyleConstants.setForeground(COMMENT, new Color(56576));
        StyleConstants.setFontFamily(COMMENT, "Monospaced");
        StyleConstants.setFontSize(COMMENT, 12);
    }
}

