/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.dialogs;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import sumo.gui.dialogs.ShaderPanel;
import sumo.resource.types.sShader;
import sumo.shader.ShaderListener;

public class shaderWindow
extends JFrame {
    JTextPane txt;
    JTextPane txtOutput;
    JTabbedPane tabs;
    ShaderPanel fragShaderPanel;
    ShaderPanel vertShaderPanel;

    public shaderWindow(sShader shader) {
        shader.getSumoShader().getCompilerOutput();
        shader.getSumoShader().addShaderListener(new ShaderListener(){

            public void recompiled() {
                shaderWindow.this.fragShaderPanel.refresh();
                shaderWindow.this.vertShaderPanel.refresh();
            }
        });
        this.setSize(800, 500);
        this.setLayout(null);
        this.tabs = new JTabbedPane();
        this.fragShaderPanel = new ShaderPanel(shader, 0);
        this.vertShaderPanel = new ShaderPanel(shader, 1);
        this.tabs.addTab("fragment", this.fragShaderPanel);
        this.tabs.addTab("vertex", this.vertShaderPanel);
        this.add(this.tabs);
        this.setTitle(shader.getFilename());
        this.setVisible(true);
        this.fragShaderPanel.refresh();
        this.vertShaderPanel.refresh();
        this.updateResize();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                shaderWindow.this.updateResize();
            }
        });
    }

    protected void updateResize() {
        this.tabs.setBounds(5, 5, this.getWidth() - 15, this.getHeight() - 45);
        this.fragShaderPanel.setBounds(0, 30, this.getWidth() - 30, this.getHeight() - 50);
        this.vertShaderPanel.setBounds(0, 30, this.getWidth() - 30, this.getHeight() - 50);
    }
}

