/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.ComponentOrientation;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import sumo.app.guitest;
import sumo.app.main;
import sumo.gui.detail.DebugGUIDetail;
import sumo.gui.detail.PluginDetail;
import sumo.gui.detailMenu.MidiSettings;
import sumo.gui.detailMenu.ProjectDetail;
import sumo.gui.detailMenu.SumoSettings;
import sumo.logger.Logger;
import sumo.opengl.AWTGLWindow;
import sumo.plugin.PluginConfig;
import sumo.project.Project;
import sumo.project.ProjectFile;
import sumo.shader.SumoShader;
import sumo.util.Files;

public class menuBar
extends JMenuBar {
    public menuBar() {
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        JMenu projectMenu = new JMenu("file");
        projectMenu.setMnemonic('f');
        JMenuItem item = new JMenuItem("project settings...");
        projectMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().setDetailPanel(new ProjectDetail());
            }
        });
        item = new JMenuItem("sumo settings...");
        projectMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().setDetailPanel(new SumoSettings());
            }
        });
        item = new JMenuItem("midi settings...");
        projectMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().setDetailPanel(new MidiSettings());
            }
        });
        item = new JMenuItem("load project...");
        projectMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)new JFrame(), "load project...", 0);
                fd.setFile("*.xml");
                fd.show();
                fd.dispose();
                if (fd.getDirectory() != null || fd.getFile() != null) {
                    String filename;
                    Project.getProject().filename = filename = fd.getDirectory() + fd.getFile();
                    ProjectFile.load(Project.getProject(), filename);
                    Project.setStatus("loaded " + filename + "...");
                }
            }
        });
        item = new JMenuItem("save project...");
        projectMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Project.getProject().filename.equals("")) {
                    FileDialog fd = new FileDialog((Frame)new JFrame(), "save project...", 1);
                    fd.setFile("*.xml");
                    fd.show();
                    fd.dispose();
                    if (fd.getDirectory() != null || fd.getFile() != null) {
                        Project.getProject().filename = fd.getDirectory() + fd.getFile();
                    }
                }
                if (Project.getProject().filename != null && !Project.getProject().filename.equals("")) {
                    ProjectFile.save(Project.getProject(), Project.getProject().filename);
                    Project.setStatus("saved as " + Project.getProject().filename + "...");
                }
            }
        });
        item = new JMenuItem("save project as...");
        projectMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 66));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)new JFrame(), "save project as...", 1);
                fd.setFile("*.xml");
                fd.show();
                fd.dispose();
                if (fd.getDirectory() != null || fd.getFile() != null) {
                    Project.getProject().filename = fd.getDirectory() + fd.getFile();
                }
                if (Project.getProject().filename != null && !Project.getProject().filename.equals("")) {
                    ProjectFile.save(Project.getProject(), Project.getProject().filename);
                    Project.setStatus("saved as " + Project.getProject().filename + "...");
                }
            }
        });
        this.add(projectMenu);
        JMenu pluginMenu = new JMenu("add layer");
        pluginMenu.setMnemonic('l');
        this.add(pluginMenu);
        ArrayList<PluginConfig> plugcfgs = Project.getProject().getPluginManager().getPluginsConfigs();
        for (int i = 0; i < plugcfgs.size(); ++i) {
            PluginConfig cfg = plugcfgs.get(i);
            item = new JMenuItem(cfg.getClassName());
            pluginMenu.add(item);
            item.setName(cfg.getClassName());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JMenuItem i = (JMenuItem)e.getSource();
                    System.out.println("try instancing: " + i.getName());
                    if (Project.getProject().getCurrentScene() == null) {
                        System.out.println("scene null");
                    }
                    if (Project.getProject().getPluginManager().getPluginInstance(i.getName()) == null) {
                        System.out.println("instance null!!");
                    }
                    Project.getProject().getCurrentScene().addLayer(Project.getProject().getPluginManager().getPluginInstance(i.getName()));
                }
            });
        }
        JMenu toolsMenu = new JMenu("tools");
        this.add(toolsMenu);
        item = new JMenuItem("create new shader");
        toolsMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumoShader.createShaderResource();
            }
        });
        item = new JMenuItem("goto prev key");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(74, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                main.gui.gotoPrevKey();
            }
        });
        item = new JMenuItem("goto next key");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(75, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                main.gui.gotoNextKey();
            }
        });
        item = new JMenuItem("delete keys");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                main.gui.gotoNextKey();
            }
        });
        item = new JMenuItem("play");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(32, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guitest.scenePanel.timeControll.play();
            }
        });
        item = new JMenuItem("go foward 1s");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().getTimer().setTime(Project.getProject().getTime() + 1.0f);
                guitest.scenePanel.repaintTimings();
                menuBar.this.repaint();
            }
        });
        item = new JMenuItem("go backward 1s");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().getTimer().setTime(Project.getProject().getTime() - 1.0f);
                guitest.scenePanel.repaintTimings();
                menuBar.this.repaint();
            }
        });
        item = new JMenuItem("go foward 1 frame");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(39, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guitest.scenePanel.moveCursorFrame(1);
            }
        });
        item = new JMenuItem("go backward 1 frame");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(37, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guitest.scenePanel.moveCursorFrame(-1);
            }
        });
        item = new JMenuItem("go foward 10 frames");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(39, 1));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guitest.scenePanel.moveCursorFrame(10);
            }
        });
        item = new JMenuItem("go backward 10 frames");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(37, 1));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guitest.scenePanel.moveCursorFrame(-10);
            }
        });
        item = new JMenuItem("preview mode");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                main.gui.switchBigLayout();
            }
        });
        item = new JMenuItem("mark next layer");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(40, 8));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginDetail.markNextLayer();
            }
        });
        item = new JMenuItem("mark previous layer");
        toolsMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(38, 8));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginDetail.markPrevLayer();
            }
        });
        JMenu resourceMenu = new JMenu("Resources");
        this.add(resourceMenu);
        item = new JMenuItem("load resource...");
        resourceMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                menuBar.openResource();
            }
        });
        item = new JMenuItem("create new shader");
        resourceMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumoShader.createShaderResource();
            }
        });
        JMenu debugMenu = new JMenu("Debug");
        this.add(debugMenu);
        item = new JMenuItem("panelnames");
        debugMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().debugGUI = !Project.getProject().debugGUI;
            }
        });
        item = new JMenuItem("copy log to clipboard");
        debugMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Logger.toClipboard();
            }
        });
        item = new JMenuItem("2nd win");
        debugMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTGLWindow wi = new AWTGLWindow();
                Project.draw2ndwin = true;
                Project.win = wi;
            }
        });
        item = new JMenuItem("debug gui timings...");
        debugMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project.getProject().setDetailPanel(new DebugGUIDetail());
            }
        });
        item = new JMenuItem("upload window screenshot");
        debugMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Rectangle rectangle = new Rectangle(main.gui.getBounds());
                    String fn = System.getProperty("java.io.tmpdir") + System.currentTimeMillis() + ".png";
                    guitest.screenshot(fn, rectangle);
                    Files.uploadScreenshot(fn);
                    Project.setStatus("screenshot of window uploaded... (drastic.net/work/autosumo/)");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static void openResource() {
        FileDialog fd = new FileDialog((Frame)new JFrame(), "load...", 0);
        fd.show();
        if (fd.getDirectory() != null || fd.getFile() != null) {
            Project.getProject().getResourceManager().add(fd.getDirectory(), fd.getFile());
        }
        fd.dispose();
        Project.getProject().setDetailPanel(null);
    }
}

