/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.sumoComponents.tab;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.sumoComponents.tab.SumoTab;
import sumo.gui.sumoComponents.tab.tabClickedListener;

public class SumoTabBar
extends JComponent {
    ArrayList<SumoTab> tabs = new ArrayList();
    public static final int TABHEIGHT = 20;
    private boolean closableTabs = false;

    public SumoTab setActive(String title) {
        for (SumoTab tab : this.tabs) {
            if (!tab.title.equals(title)) continue;
            this.setActiveTab(tab);
            return tab;
        }
        return null;
    }

    public SumoTab addTab(String title) {
        SumoTab t = new SumoTab(title);
        t.setClosable(this.closableTabs);
        this.tabs.add(t);
        this.add(t);
        t.addTabClickedListener(new tabClickedListener(){

            public void clicked(SumoTab t) {
                SumoTabBar.this.setActiveTab(t);
            }
        });
        return t;
    }

    public void setActiveTab(SumoTab t) {
        for (SumoTab tab : this.tabs) {
            if (!tab.getActive()) continue;
            tab.setActive(false);
            tab.repaint();
        }
        t.setActive(true);
        t.repaint();
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(Settings.SUMO2_BG);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i <= this.getWidth() + 200; i += 200) {
            Icons.drawIcon(g, Icons.IMAGE_GRADIENT, i, 22);
        }
        int posx = 10;
        Graphics2D g2 = (Graphics2D)g;
        for (SumoTab t : this.tabs) {
            int w = 20 + (int)Settings.font.getStringBounds(t.title, g2.getFontRenderContext()).getWidth();
            t.setBounds(posx, 0, w, 20);
            if (t.getActive()) {
                g.setColor(Settings.SUMO2_BG);
                g.fillRect(posx, 20, t.getWidth(), 20);
            }
            posx += w;
        }
        g.setColor(Settings.SUMO2_DARKER);
        g.drawLine(0, 19, this.getWidth(), 19);
        this.paintComponents(g);
    }
}

