/*
 * Decompiled with CFR 0.152.
 */
package sumo.input.midi;

import javax.sound.midi.ShortMessage;
import sumo.input.midi.MidiBindingIF;
import sumo.input.midi.MidiListener;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedFloat;
import sumo.math.vec2i;
import sumo.project.Project;

public class MidiFloatBinding
implements MidiBindingIF {
    int which = -1;
    KeyframedFloat fl;
    private float lastValue = -1110.0f;
    private float v = -1110.0f;
    boolean ignoreEvent = false;
    vec2i mapPos = new vec2i();

    public MidiFloatBinding(int id, KeyframedFloat f) {
        this.fl = f;
        this.which = id;
        Project.getProject().getMidiController().addMidiListener(new MidiListener(){

            public void signalReceived(int w, int value) {
                MidiFloatBinding.this.ignoreEvent = true;
                MidiFloatBinding.this.v = (float)value / 127.0f;
                if (MidiFloatBinding.this.which == w && MidiFloatBinding.this.fl.getValue() != MidiFloatBinding.this.v) {
                    MidiFloatBinding.this.fl.setValue(MidiFloatBinding.this.v);
                }
            }
        });
        this.fl.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                if (MidiFloatBinding.this.fl.getValue() != MidiFloatBinding.this.lastValue && !MidiFloatBinding.this.ignoreEvent) {
                    try {
                        ShortMessage onMessage = new ShortMessage();
                        onMessage.setMessage(176, 0, MidiFloatBinding.this.which, (int)(MidiFloatBinding.this.fl.getValue() * 127.0f));
                        if (Project.getProject().getMidiController().recout != null) {
                            Project.getProject().getMidiController().recout.send(onMessage, -1L);
                        }
                        MidiFloatBinding.this.lastValue = MidiFloatBinding.this.fl.getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                MidiFloatBinding.this.ignoreEvent = false;
            }
        });
    }

    public int getKey() {
        return this.which;
    }

    public Object getObj() {
        return this.fl;
    }

    public vec2i getMapPosition() {
        return this.mapPos;
    }

    public void setMapPosition(vec2i pos) {
        this.mapPos = pos;
    }
}

