/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.UUID;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.effects.EffectConfig;
import sumo.gui.AbstractLine;
import sumo.gui.detail.Elements.PluginButton;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedFloat;
import sumo.keyframing.KeyframedInt;
import sumo.keyframing.KeyframedResource;
import sumo.logger.Logger;
import sumo.opengl.FBO;
import sumo.opengl.FBOManager;
import sumo.opengl.FullScreenRect;
import sumo.opengl.common;
import sumo.plugin.PluginConfig;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.shader.ShaderPartProgram;
import sumo.shader.ShaderVariable;
import sumo.shader.SumoShader;
import sumoTween.Tweener;
import sumoTween.TweenerXML;
import sumoTween.easing.Linear;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin
implements PluginIF {
    private PluginConfig config;
    ArrayList<EffectConfig> effects = new ArrayList();
    static int guiIdCounter = 0;
    boolean isMinimized = false;
    boolean isVisible = true;
    ArrayList<PluginButton> pluginButtons = new ArrayList();
    AbstractLine abstractLine = null;
    private int renderFrameBuffer = -1;
    int guiID = 0;
    ArrayList<Object> vars = new ArrayList();
    private boolean effectLinesNeedUpdate = false;
    private SumoShader effectShader;
    private ArrayList<ShaderVariable> updateFloats = new ArrayList();
    private ArrayList<ShaderVariable> updateInts = new ArrayList();
    private AbstractLine effectFolder;
    sShader shaderResource;

    @Override
    public void setConfig(PluginConfig config) {
        this.config = config;
    }

    @Override
    public PluginConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public abstract float getVersion();

    @Override
    public abstract String getAuthor();

    @Override
    public abstract void render();

    @Override
    public abstract void init();

    @Override
    public abstract void saveXML(Element var1);

    @Override
    public abstract void loadXML(Element var1);

    @Override
    public void setPlugKeys(String fieldname, boolean keyframed, Object keys, int i) {
    }

    @Override
    public void setResource(String title, String filename, String path) {
    }

    @Override
    public void setValue(String title, boolean booleanvalue) {
    }

    @Override
    public int getID() {
        return this.guiID;
    }

    @Override
    public void initVariables() {
        this.guiID = ++guiIdCounter;
        Field[] publicFields = this.getClass().getFields();
        for (int i = 0; i < publicFields.length; ++i) {
            Object f;
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains("weener")) {
                try {
                    f = new Tweener(new Linear());
                    ((Tweener)f).setKeyframed(false);
                    ((Tweener)f).setTimer(Project.getProject().getTimer());
                    publicFields[i].set(this, f);
                    ((Tweener)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                    ((Tweener)f).set(0.0f, 0.5f);
                }
                catch (Exception e) {
                    Logger.log(this.getClass(), e);
                }
            }
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedInt.classSimpleName)) {
                try {
                    f = new KeyframedInt();
                    ((KeyFramedBase)f).setKeyframingEnabled(true);
                    publicFields[i].set(this, f);
                    ((KeyframedInt)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                }
                catch (Exception e) {
                    Logger.log(this.getClass(), e);
                }
            }
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedBoolean.classSimpleName)) {
                try {
                    f = new KeyframedBoolean();
                    ((KeyFramedBase)f).setKeyframingEnabled(true);
                    publicFields[i].set(this, f);
                    ((KeyframedBoolean)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                }
                catch (Exception e) {
                    Logger.log(this.getClass(), e);
                }
            }
            if (!publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedResource.classSimpleName)) continue;
            try {
                f = new KeyframedResource();
                ((KeyFramedBase)f).setKeyframingEnabled(false);
                publicFields[i].set(this, f);
                ((KeyframedResource)f).setName(publicFields[i].getName());
                this.addVariable(f);
                continue;
            }
            catch (Exception e) {
                Logger.log(this.getClass(), e);
            }
        }
    }

    @Override
    public boolean isMinimized() {
        return this.isMinimized;
    }

    @Override
    public void setMinimized(boolean m) {
        this.isMinimized = m;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public int getFrameBuffer() {
        return this.renderFrameBuffer;
    }

    @Override
    public void setFrameBuffer(int i) {
        this.renderFrameBuffer = i;
    }

    public void addVariable(Object v) {
        this.vars.add(v);
    }

    @Override
    public void replaceVariable(Object kf, Tweener tween) {
        for (int i = 0; i < this.vars.size(); ++i) {
            if (!this.vars.get(i).equals(kf)) continue;
            this.vars.set(i, tween);
        }
    }

    @Override
    public Object[] getVariables() {
        return this.vars.toArray();
    }

    @Override
    public Object getVariable(String title) {
        for (int i = 0; i < this.vars.size(); ++i) {
            Object o = this.vars.get(i);
            if (!(o instanceof KeyframedFloat || o instanceof KeyframedInt || o instanceof KeyframedBoolean || o instanceof KeyframedResource ? ((KeyFramedIF)this.vars.get(i)).getName().equals(title) : o instanceof Tweener && ((Tweener)this.vars.get(i)).getName().equals(title))) continue;
            return this.vars.get(i);
        }
        return null;
    }

    @Override
    public void save(Element root) {
        Element xmlPlug = root.getOwnerDocument().createElement("plugin");
        xmlPlug.setAttribute("class", this.getConfig().getClassName());
        xmlPlug.setAttribute("visible", String.valueOf(this.isVisible()));
        xmlPlug.setAttribute("minimized", String.valueOf(this.isMinimized()));
        this.saveEffectXML(xmlPlug);
        xmlPlug.setAttribute("framebuffer", String.valueOf(this.getFrameBuffer()));
        for (int i = 0; i < this.vars.size(); ++i) {
            Object o = this.vars.get(i);
            if (o instanceof Tweener) {
                Element el = TweenerXML.toXML(xmlPlug, (Tweener)o);
                ((Element)el.getFirstChild()).setAttribute("height", String.valueOf(this.getAbstractLine().drawableLine.getLineHeight()));
                xmlPlug.appendChild(el);
                continue;
            }
            if (o instanceof KeyframedBoolean) {
                ((KeyframedBoolean)o).save(xmlPlug);
                continue;
            }
            if (!(o instanceof KeyframedResource)) continue;
            ((KeyframedResource)o).save(xmlPlug);
        }
        root.appendChild(xmlPlug);
        Element xmlPlugExtra = root.getOwnerDocument().createElement("pluginsettings");
        this.saveXML(xmlPlugExtra);
        xmlPlug.appendChild(xmlPlugExtra);
    }

    @Override
    public void setAbstractLine(AbstractLine newline) {
        this.abstractLine = newline;
    }

    @Override
    public AbstractLine getAbstractLine() {
        return this.abstractLine;
    }

    @Override
    public String getSubTitle() {
        return null;
    }

    @Override
    public void addPluginButton(PluginButton but) {
        this.pluginButtons.add(but);
    }

    @Override
    public ArrayList<PluginButton> getPluginButtons() {
        return this.pluginButtons;
    }

    @Override
    public void addEffect(EffectConfig effectConfig) {
        this.effects.add(effectConfig);
        if (effectConfig.getType() == 1) {
            if (this.effectShader == null) {
                this.initShader(null);
            }
            this.effectShader.addPart(effectConfig.getShaderPart());
            this.effectLinesNeedUpdate = true;
        }
    }

    @Override
    public boolean hasEffects() {
        return this.effectShader != null;
    }

    @Override
    public void renderShaderEffects(FBO fbo) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        FBOManager.glViewport();
        GL11.glLoadIdentity();
        GL11.glClear(16640);
        common.switchTo2d();
        GL11.glLoadIdentity();
        if (this.effectShader == null) {
            this.initShader(null);
        }
        if (this.effectLinesNeedUpdate) {
            this.updateEffectLines();
        }
        GL11.glDisable(2903);
        GL11.glDisable(3042);
        GL11.glDisable(2896);
        GL11.glEnable(3553);
        boolean useEffectShader = true;
        if (useEffectShader) {
            this.effectShader.bind();
            for (ShaderVariable v : this.updateFloats) {
                this.effectShader.setUniform1f(v.getLoc(this.effectShader), v.getKeyframed().getValue());
            }
            this.effectShader.setMultiTexture(0, fbo.getTexture().getID(), "_ctex00");
        }
        FullScreenRect.draw(fbo.getTexture());
        if (useEffectShader) {
            this.effectShader.unbind();
        }
        common.switchTo3d();
        FBOManager.glViewport();
        GL11.glClear(256);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public sShader getShaderResource() {
        return this.shaderResource;
    }

    private void initShader(sShader sh) {
        if (sh != null) {
            this.shaderResource = sh;
            this.effectShader = sh.getSumoShader();
            this.effectShader.alpha = true;
            this.effectLinesNeedUpdate = true;
        } else {
            this.effectShader = new SumoShader();
            this.effectShader.alpha = true;
            this.effectShader.addPart("texture");
            this.effectLinesNeedUpdate = true;
            String effectsFilename = "shader_" + UUID.randomUUID().toString();
            this.shaderResource = new sShader();
            this.shaderResource.setFilename(effectsFilename);
            this.shaderResource.setShader(this.effectShader);
            Project.getProject().getResourceManager().add(this.shaderResource);
        }
    }

    void updateEffectLines() {
        if (this.effectFolder == null) {
            this.effectFolder = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 2, "effects", null);
            this.getAbstractLine().childs.add(this.effectFolder);
        } else {
            this.effectFolder.childs.clear();
        }
        for (ShaderPartProgram part : this.effectShader.getProgramms()) {
            for (ShaderVariable v : part.getUniforms()) {
                guiFloat f = null;
                f = new guiFloat(v.getKeyframed());
                v.getKeyframed().setName(v.getName());
                AbstractLine al = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, v.getName(), f);
                this.effectFolder.childs.add(al);
                this.updateFloats.add(v);
            }
        }
        this.getAbstractLine().rebuildPluginPanel();
        this.effectLinesNeedUpdate = false;
    }

    @Override
    public int getNumEffects() {
        return this.effects.size();
    }

    @Override
    public ArrayList<EffectConfig> getEffects() {
        return this.effects;
    }

    public void saveEffectXML(Element root) {
        if (this.hasEffects()) {
            Element fx = root.getOwnerDocument().createElement("effects");
            fx.setAttribute("shaderfilename", this.shaderResource.getFilename());
            root.appendChild(fx);
            for (EffectConfig cfg : this.effects) {
                cfg.saveXML(root);
            }
        }
    }

    @Override
    public void loadEffectXML(Element root) {
        NodeList nl = root.getElementsByTagName("effects");
        if (nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            String shaderfn = el.getAttribute("shaderfilename");
            this.initShader((sShader)Project.getProject().getResourceManager().getResourceByFileName(shaderfn));
        }
    }
}

