/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugin;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.gui.dialogs.exceptionDialog;
import sumo.logger.Logger;
import sumo.plugin.PluginConfig;
import sumo.plugin.PluginIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    ArrayList<PluginConfig> plugs = new ArrayList();
    static String configFile = "config/plugins.xml";

    public PluginManager() {
        this.loadConfig(configFile);
    }

    void loadConfig(String filename) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            if (System.getProperty("sumofromjar") != null && System.getProperty("sumofromjar").equals("true") || System.getProperty("sumo_webstart") != null && System.getProperty("sumo_webstart").equals("true")) {
                configFile = "/plugins.xml";
                doc = docBuilder.parse(this.getClass().getResource(configFile).openStream());
            } else {
                doc = docBuilder.parse(filename);
            }
            doc.getDocumentElement().normalize();
            NodeList xmlResources = doc.getElementsByTagName("plugin");
            for (int i = 0; i < xmlResources.getLength(); ++i) {
                this.plugs.add(new PluginConfig((Element)xmlResources.item(i)));
            }
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
    }

    public PluginIF getPluginInstance(String plugname) {
        PluginIF c = null;
        PluginConfig foundConfig = null;
        for (PluginConfig cfg : this.plugs) {
            if (!cfg.getClassName().equals(plugname)) continue;
            foundConfig = cfg;
        }
        if (foundConfig != null) {
            try {
                Class<?> testclass = Class.forName(plugname);
                c = (PluginIF)testclass.newInstance();
                c.setConfig(foundConfig);
                c.initVariables();
                Logger.log(this.getClass(), "plugin instanced: " + c.getName() + " v" + c.getVersion() + " by " + c.getAuthor());
            }
            catch (Exception e) {
                Logger.log(this.getClass(), "pluginloader: plugin not found: " + plugname, e);
            }
        } else {
            Logger.log(this.getClass(), "plugin not found:" + plugname);
        }
        return c;
    }

    public ArrayList<PluginConfig> getPluginsConfigs() {
        return this.plugs;
    }
}

