/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.particleTest;

import org.lwjgl.opengl.GL11;
import sumo.plugins.particleTest.Particle;
import sumo.resource.types.textureFile;
import sumo.v3d.math.Vec3f;

public class ParticleSystem {
    Particle[] particles = new Particle[500];
    public static final int RENDERMODE_POINTS = 0;
    public static final int RENDERMODE_TEXTUREBILLBOARD = 1;
    private int rendermode = 0;
    Vec3f emiterStartSize = new Vec3f(0.1f, 0.1f, 0.1f);
    Vec3f emiterEndSize = new Vec3f(4.0f, 4.0f, 4.0f);
    Vec3f emiterEndPos = new Vec3f(4.0f, 1.0f, 1.0f);
    Vec3f emiterStartPos = new Vec3f(0.0f, 0.0f, 0.0f);
    float sizeMin = 0.4f;
    float sizeMax = 1.0f;
    float lifetime = 10.0f;
    float speedVariance = 0.8f;
    private float emitFreq;
    protected textureFile currenTexture = null;
    private float fadeOut = 0.8f;
    private float alpha;

    public ParticleSystem() {
        this.initParticles();
    }

    private void initParticles() {
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new Particle();
            this.initParticle(i, 0.0f);
        }
    }

    private void initParticle(int i, float startTime) {
        this.particles[i].dead = false;
        this.particles[i].pos.clear();
        this.particles[i].pos.x.setValue(startTime, this.emiterStartPos.x + (float)Math.random() * this.emiterStartSize.x - this.emiterStartSize.x / 2.0f);
        this.particles[i].pos.y.setValue(startTime, this.emiterStartPos.y + (float)Math.random() * this.emiterStartSize.y - this.emiterStartSize.y / 2.0f);
        this.particles[i].pos.z.setValue(startTime, this.emiterStartPos.z + (float)Math.random() * this.emiterStartSize.z - this.emiterStartSize.z / 2.0f);
        float speed = (float)Math.random() * this.speedVariance + 1.0f;
        float lifeTimeVariance = 0.8f * (float)Math.random();
        this.particles[i].pos.x.setValue(startTime + this.lifetime * lifeTimeVariance, speed * (this.emiterEndPos.x + (float)Math.random() * this.emiterEndSize.x - this.emiterEndSize.x / 2.0f));
        this.particles[i].pos.y.setValue(startTime + this.lifetime * lifeTimeVariance, speed * (this.emiterEndPos.y + (float)Math.random() * this.emiterEndSize.y - this.emiterEndSize.y / 2.0f));
        this.particles[i].pos.z.setValue(startTime + this.lifetime * lifeTimeVariance, speed * (this.emiterEndPos.z + (float)Math.random() * this.emiterEndSize.z - this.emiterEndSize.z / 2.0f));
        this.particles[i].endTime = startTime + this.lifetime * lifeTimeVariance;
        this.particles[i].size = (float)Math.random() * (this.sizeMax - this.sizeMin) + this.sizeMin;
        this.particles[i].alpha.clear(this.alpha);
        this.particles[i].alpha.set(startTime + this.lifetime * lifeTimeVariance * this.fadeOut, this.alpha, 2);
        this.particles[i].alpha.set(startTime + this.lifetime * lifeTimeVariance, 0.0f, 2);
    }

    public void render(float time) {
        if (this.rendermode == 0) {
            for (int i = 0; i < this.particles.length; ++i) {
                if (this.particles[i].dead) continue;
                this.particles[i].render(time);
            }
        } else if (this.rendermode == 1 && this.currenTexture != null) {
            textureFile.enable();
            this.currenTexture.bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glDisable(2896);
            GL11.glDisable(2884);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDepthMask(false);
            for (int i = 0; i < this.particles.length; ++i) {
                if (this.particles[i].dead) continue;
                this.particles[i].drawBillBoard(time, this.currenTexture.width);
            }
            GL11.glDepthMask(true);
        }
        this.reInitParticle(time);
    }

    private void reInitParticle(float time) {
        int ind;
        float deadRatio = (float)this.getNumDeadParticles() / (float)this.particles.length;
        if (this.emitFreq < deadRatio && (ind = this.getDeadParticle()) != -1) {
            this.initParticle(ind, time);
        }
    }

    private int getDeadParticle() {
        for (int i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].dead) continue;
            return i;
        }
        return -1;
    }

    int getNumDeadParticles() {
        int count = 0;
        for (int i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].dead) continue;
            ++count;
        }
        return count;
    }

    public void setEmmitFrequency(float emit) {
        this.emitFreq = emit;
    }

    public void setSpeedVariance(float speedVar) {
        this.speedVariance = speedVar;
    }

    public void setRenderMode(int intValue) {
        this.rendermode = intValue;
    }

    public void setFadeOut(float value) {
        this.fadeOut = value;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }
}

