/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.playSound;

import org.w3c.dom.Element;
import sumo.audio.AudioSystem;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.project.Project;
import sumo.resource.types.AudioFile;
import sumo.resource.types.v3d;
import sumoTween.Tweener;
import sumoTween.easing.Cubic;

public class PlaySound
extends Plugin {
    public KeyframedResource soundFile;
    AudioFile sound;
    boolean playing = false;
    Tweener flash;
    long lastFFT = 0L;

    public void init() {
        this.soundFile.setResource(new v3d());
        this.soundFile.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                PlaySound.this.sound = (AudioFile)PlaySound.this.soundFile.getResource();
            }
        });
        this.flash = new Tweener(new Cubic());
        this.flash.setKeyframed(true);
        this.flash.setTimer(Project.getProject().getTimer());
        this.flash.clear(0.0f);
    }

    public void render() {
        AudioSystem audiosys = Project.getProject().getAudioSystem();
        if (this.sound != null) {
            if (Project.getProject().getTimer().isPlaying()) {
                if (!this.playing) {
                    audiosys.setTime(this.sound, Project.getProject().getTime());
                    this.playing = true;
                    audiosys.play(this.sound);
                }
                if (audiosys.getTime(this.sound) < Project.getProject().getTime() - 0.1f || audiosys.getTime(this.sound) > Project.getProject().getTime() + 0.1f) {
                    audiosys.setTime(this.sound, Project.getProject().getTime());
                }
            } else {
                audiosys.stop(this.sound);
                this.playing = false;
                this.flash.clear(0.0f);
            }
        }
    }

    public String getAuthor() {
        return "pandur";
    }

    public float getVersion() {
        return 0.0f;
    }

    public void loadXML(Element root) {
    }

    public void saveXML(Element root) {
    }
}

