/*
 * Decompiled with CFR 0.152.
 */
package sumo.project;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.gui.dialogs.exceptionDialog;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.project.SceneIF;
import sumo.resource.types.AudioFile;
import sumo.timing.TimerAudioSys;
import sumo.timing.timerGUI;
import sumoTween.Tweener;
import sumoTween.TweenerXML;

public class ProjectFile {
    public static void load(Project prj, String filename) {
        if (filename == null) {
            return;
        }
        System.out.println("loading project...");
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(filename);
            doc.getDocumentElement().normalize();
            Element etime = (Element)doc.getElementsByTagName("timer").item(0);
            if (etime != null) {
                TimerAudioSys t = new TimerAudioSys();
                AudioFile fmf = new AudioFile();
                fmf.setFilename(etime.getAttribute("filename"));
                fmf.setPath(etime.getAttribute("path"));
                t.setAudioFile(fmf);
                Project.getProject().getResourceManager().add(fmf);
                Project.getProject().setTimer(t);
            }
            Element ePrj = (Element)doc.getElementsByTagName("project").item(0);
            prj.setProjectName(ePrj.getAttribute("name"));
            prj.setLength(Integer.parseInt(ePrj.getAttribute("length")));
            prj.numResourcesPredicted = Integer.parseInt(ePrj.getAttribute("numresources"));
            NodeList xmlResources = doc.getElementsByTagName("resources");
            prj.getResourceManager().loadResourcesXML((Element)xmlResources.item(0));
            ArrayList<KeyframedResource> kfresources = new ArrayList<KeyframedResource>();
            NodeList xmlScenes = doc.getElementsByTagName("scene");
            for (int i = 0; i < xmlScenes.getLength(); ++i) {
                Element e = (Element)xmlScenes.item(i);
                int n = Integer.parseInt(e.getAttribute("num"));
                int c = 0;
                if (!e.getAttribute("color").equals("")) {
                    c = Integer.parseInt(e.getAttribute("color"));
                }
                SceneIF scene = prj.getScene(n);
                scene.loadTiming(e);
                scene.setColor(c);
                NodeList scenePlugins = e.getElementsByTagName("plugin");
                for (int j = 0; j < scenePlugins.getLength(); ++j) {
                    Element el = (Element)scenePlugins.item(j);
                    String className = el.getAttribute("class");
                    PluginIF plug = prj.getPluginManager().getPluginInstance(className);
                    if (!el.getAttribute("framebuffer").equals("")) {
                        plug.setFrameBuffer(Integer.parseInt(el.getAttribute("framebuffer")));
                    }
                    if (!el.getAttribute("visible").equals("")) {
                        plug.setVisible(Boolean.parseBoolean(el.getAttribute("visible")));
                    }
                    if (!el.getAttribute("minimized").equals("")) {
                        plug.setMinimized(Boolean.parseBoolean(el.getAttribute("minimized")));
                    }
                    scene.addLayer(plug);
                    plug.loadEffectXML(el);
                    NodeList tweenElements = el.getElementsByTagName("tween");
                    for (int k = 0; k < tweenElements.getLength(); ++k) {
                        Element ele = (Element)tweenElements.item(k);
                        Tweener kf = (Tweener)plug.getVariable(ele.getAttribute("name"));
                        if (kf == null) continue;
                        TweenerXML.fromXML(ele, kf);
                    }
                    NodeList kframed = el.getElementsByTagName("keyframed");
                    for (int k = 0; k < kframed.getLength(); ++k) {
                        Element ek = (Element)kframed.item(k);
                        String name = ek.getAttribute("name");
                        if (name.equals("")) continue;
                        KeyFramedIF kf = (KeyFramedIF)plug.getVariable(name);
                        KeyFramedBase.parseXML(kf, ek);
                        if (kf instanceof KeyframedResource) {
                            kfresources.add((KeyframedResource)kf);
                        }
                        prj.getResourceManager().setPingResourceSelectsAfterLoading(kfresources);
                    }
                    Element sett = (Element)el.getElementsByTagName("pluginsettings").item(0);
                    if (sett == null) continue;
                    plug.loadXML(sett);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new exceptionDialog(e);
        }
    }

    public static void save(Project prj, String filename) {
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("sumo");
            doc.appendChild(root);
            Element xmlSub = doc.createElement("project");
            xmlSub.setAttribute("numresources", String.valueOf(prj.getResourceManager().getAllResources().size()));
            xmlSub.setAttribute("name", prj.getProjectName());
            xmlSub.setAttribute("length", String.valueOf(prj.getLength()));
            root.appendChild(xmlSub);
            if (Project.getProject().getTimer() instanceof timerGUI) {
                ((timerGUI)Project.getProject().getTimer()).saveXML(xmlSub);
            } else if (Project.getProject().getTimer() instanceof TimerAudioSys) {
                ((TimerAudioSys)Project.getProject().getTimer()).saveXML(xmlSub);
            }
            prj.getResourceManager().saveResources(root);
            prj.saveScenes(root);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("encoding", "UTF-8");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
                out.write(xmlString);
                ((Writer)out).close();
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException e) {}
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

