/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.app.guitest;
import sumo.app.loader.LoadingBarIF;
import sumo.app.loader.LoadingCircle;
import sumo.app.main;
import sumo.gui.AbstractLine;
import sumo.gui.dialogs.exceptionDialog;
import sumo.gui.dialogs.selector.SelectorItem;
import sumo.keyframing.KeyframedResource;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.project.SceneIF;
import sumo.resource.ResourcesChangedEvent;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.resource.resourceType;
import sumo.resource.types.FBOResource;
import sumo.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    ArrayList<resourceIF> resources = new ArrayList();
    ArrayList<ResourcesChangedEvent> resourcesChangedListeners = new ArrayList();
    Vector resourceTypes = null;
    public static boolean useRelativePath = false;
    private boolean isAllLoaded = true;
    KeyframedResource activeResourceSelect = null;
    private boolean loadFromJar = false;
    ArrayList<String> alternativPaths = new ArrayList();
    ArrayList<KeyframedResource> allKeyframedResources;
    public float loadingbarPercent = 0.0f;
    LoadingBarIF circle = new LoadingCircle();

    public ArrayList<resourceIF> getAllResources() {
        return this.resources;
    }

    public ArrayList<resourceIF> getResources(Class c) {
        ArrayList<resourceIF> rs = new ArrayList<resourceIF>();
        for (resourceIF r : this.resources) {
            if (!r.getClass().equals(c)) continue;
            rs.add(r);
        }
        return rs;
    }

    public String[][] getAllResourcesList(String s) {
        int count = 0;
        Logger.log(this.getClass(), "getAllResourcesList: " + s);
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            if (r.getTypeDescr().equals(s)) {
                ++count;
            }
            Logger.log(this.getClass(), "resource: " + r.getTypeDescr());
        }
        String[][] ret = new String[count][3];
        count = 0;
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            if (!r.getTypeDescr().equals(s)) continue;
            ret[count][0] = r.filename;
            ret[count][1] = r.getTypeDescr();
            ret[count][2] = r.getInfo();
            ++count;
        }
        return ret;
    }

    public void addResourceType(resourceType rt) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new Vector();
        }
        this.resourceTypes.add(rt);
    }

    public void init() {
        Logger.log(this.getClass(), "resourcemanager init");
    }

    public resourceIF getResourceLoaderInstance(String classname) {
        Logger.log(this.getClass(), "getResourceInstance");
        resourceIF c = null;
        try {
            Logger.log(this.getClass(), "classname:" + classname);
            Class<?> testclass = Class.forName(classname);
            c = (resourceIF)testclass.newInstance();
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
        return c;
    }

    public void addAlternativePath(String s) {
        if (!this.alternativPaths.contains(s)) {
            this.alternativPaths.add(s);
        }
    }

    public void fixResourcePath(resourceIF r) {
        if (useRelativePath) {
            r.setPath("data/");
        }
        if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) {
            for (int i = 0; i < this.alternativPaths.size(); ++i) {
                r.setPath(this.alternativPaths.get(i));
                if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) continue;
                return;
            }
        }
    }

    public void addNoCheck(resourceIF r) {
        this.resources.add(r);
        this.isAllLoaded = false;
    }

    public void add(resourceIF r) {
        if (!r.getFilename().startsWith("pbuffer") && !r.getFilename().startsWith("_vsys")) {
            this.alternativPaths.add(r.getPath());
        }
        if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) {
            this.fixResourcePath(r);
        }
        this.resources.add(r);
        this.isAllLoaded = false;
        this.notifyResourceChangedListeners();
    }

    public static boolean fileExist(String filename) {
        if (filename.contains("framebuffer 3 depth")) {
            return true;
        }
        if (filename.contains("framebuffer 1")) {
            return true;
        }
        if (filename.contains("framebuffer 2")) {
            return true;
        }
        if (filename.contains("framebuffer 3 color")) {
            return true;
        }
        if (filename.startsWith("shader_")) {
            return true;
        }
        File f = new File(filename);
        if (!f.exists()) {
            Logger.log(ResourceManager.class, "does not exist:" + filename);
            return false;
        }
        return true;
    }

    public resourceIF add(String path, String filename) {
        if (this.allreadyloaded(filename)) {
            return this.getResourceByFileName(filename);
        }
        if (this.getResourceByFileName(filename) != null) {
            return null;
        }
        if (filename.equals("pbuffer")) {
            return null;
        }
        if (filename.equals("_vsys")) {
            return null;
        }
        this.addAlternativePath("demo/");
        this.addAlternativePath(path);
        boolean found = false;
        resourceIF r = null;
        try {
            if (this.resourceTypes == null) {
                this.init();
            }
            for (int i = 0; i < this.resourceTypes.size(); ++i) {
                resourceType rt = (resourceType)this.resourceTypes.get(i);
                for (int a = 0; a < rt.getFilenameExtensions().length; ++a) {
                    if (!filename.toLowerCase().endsWith("." + rt.getFilenameExtensions()[a].toLowerCase())) continue;
                    Logger.log(this.getClass(), "adding resource:" + path + "/" + filename + " class: _" + rt.getLoaderclass() + "_");
                    r = this.getResourceLoaderInstance(rt.getLoaderclass());
                    r.setFilename(filename);
                    r.setPath(path);
                    this.isAllLoaded = false;
                    found = true;
                }
            }
            if (r != null) {
                this.fixResourcePath(r);
                this.resources.add(r);
            } else {
                Logger.log(this.getClass(), "RESOURCE NOT ADDED, IS NULL");
            }
            this.notifyResourceChangedListeners();
            return r;
        }
        catch (Exception e) {
            Logger.log(this.getClass(), "resourceloader error", e);
            this.notifyResourceChangedListeners();
            return null;
        }
    }

    boolean allreadyloaded(String fn) {
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF r = this.resources.get(i);
            if (!r.getFilename().equals(fn)) continue;
            return true;
        }
        return false;
    }

    public Vector getResourceNames() {
        Vector v = new Vector();
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF r = this.resources.get(i);
            Vector<String> info = new Vector<String>();
            info.add(r.getPath());
            info.add(r.getFilename());
            info.add(r.getTypeDescr());
            v.add(info);
        }
        return v;
    }

    public resourceIF getResourceByFileName(String s) {
        if (s == null) {
            return null;
        }
        resourceIF r = null;
        resourceIF rr = null;
        for (int i = 0; i < this.resources.size(); ++i) {
            r = this.resources.get(i);
            if (r == null) {
                Logger.log(this.getClass(), "OUGH!!!!");
                continue;
            }
            if (!r.getFilename().equals(s)) continue;
            rr = r;
        }
        return rr;
    }

    public int numResources(String filter) {
        int count = 0;
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (!t.getTypeDescr().equals(filter)) continue;
            ++count;
        }
        return count;
    }

    public void printAllResources() {
        Logger.log(this.getClass(), "-----all resources");
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            Logger.log(this.getClass(), t.getFilename());
        }
        Logger.log(this.getClass(), "---");
    }

    public String[] getResourceNamesArray(String filter) {
        Logger.log(this.getClass(), "namesarray:");
        int count = 0;
        String[] titles = new String[this.numResources(filter)];
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (t.getTypeDescr().equals(filter)) {
                titles[count] = t.getFilename();
                ++count;
            }
            Logger.log(this.getClass(), "namesarray:" + t.getFilename());
        }
        return titles;
    }

    public void copyResourcesTo(String toPath) {
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (!t.getFilename().startsWith("pbuffer") && !t.getFilename().startsWith("_vsys")) {
                Files.copyfile(t.getPath() + t.getFilename(), toPath + t.getFilename());
            }
            Logger.log(this.getClass(), "_" + t.getFilename());
        }
    }

    public void checkAllLoaded() {
        ArrayList<resourceIF> l = this.getAllResources();
        this.isAllLoaded = true;
        for (resourceIF r : l) {
            if (r.isLoaded() || r instanceof FBOResource) continue;
            System.out.println("not loaded:" + r.getFilename());
            this.isAllLoaded = false;
            return;
        }
    }

    public void loadResources() {
        if (!this.isAllLoaded()) {
            ArrayList<resourceIF> l = this.getAllResources();
            for (int i = 0; i < l.size(); ++i) {
                resourceIF r = l.get(i);
                if (r == null) {
                    Logger.log(this.getClass(), "resource is null!");
                    continue;
                }
                if (r.isLoaded()) continue;
                r.load();
            }
            this.isAllLoaded = true;
            System.gc();
            guitest.updateResources();
            if (this.allKeyframedResources != null) {
                for (KeyframedResource k : this.allKeyframedResources) {
                    k.notifyKeysChanged();
                }
            }
            this.allKeyframedResources = null;
            this.notifyResourceChangedListeners();
        }
    }

    public void setAllLoaded(boolean b) {
        this.isAllLoaded = b;
    }

    public boolean getLoadFromJar() {
        return false;
    }

    public JarFile getJarFile() {
        return null;
    }

    public ArrayList<SelectorItem> getAsGuiITems(resourceIF restype) {
        ArrayList<SelectorItem> items = new ArrayList<SelectorItem>();
        ArrayList<resourceIF> resources2 = Project.getProject().getResourceManager().getAllResources();
        for (int i = 0; i < resources2.size(); ++i) {
            if (restype != null && !restype.getTypeDescr().equals(resources2.get(i).getTypeDescr())) continue;
            SelectorItem item = new SelectorItem();
            item.setTitle(resources2.get(i).getFilename());
            item.setDescr(resources2.get(i).getPath() + " - " + resources2.get(i).getInfo());
            item.setObj(resources2.get(i));
            item.setIcon(resources2.get(i).getIcon());
            items.add(item);
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object a, Object b) {
                SelectorItem ia = (SelectorItem)a;
                SelectorItem ib = (SelectorItem)b;
                return ((resourceIF)ia.getObj()).getFilename().compareTo(((resourceIF)ib.getObj()).getFilename());
            }
        });
        return items;
    }

    public boolean isAllLoaded() {
        return this.isAllLoaded;
    }

    public void saveResources(Element root) {
        Element xmlResources = root.getOwnerDocument().createElement("resources");
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            Element el = root.getOwnerDocument().createElement("resource");
            el.setAttribute("filename", r.getFilename());
            el.setAttribute("path", r.getPath());
            el.setAttribute("isRealFile", String.valueOf(r.isRealFile()));
            r.saveXML(el);
            xmlResources.appendChild(el);
        }
        root.appendChild(xmlResources);
    }

    public void setPingResourceSelectsAfterLoading(ArrayList<KeyframedResource> f) {
        this.allKeyframedResources = f;
    }

    public resourceIF addByClassName(Element er) {
        resourceIF r = null;
        Logger.log(this.getClass(), "loading by classname: " + er.getAttribute("class"));
        try {
            r = (resourceIF)Class.forName(er.getAttribute("class")).newInstance();
            r.setFilename(er.getAttribute("filename"));
            r.loadXML(er);
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        this.add(r);
        this.notifyResourceChangedListeners();
        return r;
    }

    public void loadResourcesXML(Element xmlResources) {
        if (xmlResources == null) {
            return;
        }
        NodeList ress = xmlResources.getElementsByTagName("resource");
        for (int i = 0; i < ress.getLength(); ++i) {
            Element el = (Element)ress.item(i);
            if (el.getAttribute("class").equals("")) continue;
            this.addByClassName(el);
        }
        this.notifyResourceChangedListeners();
    }

    public boolean loadingBar() {
        return this.loadingBar(this.circle);
    }

    public boolean loadingBar(LoadingBarIF bar) {
        this.checkAllLoaded();
        if (!this.isAllLoaded()) {
            ArrayList<resourceIF> l = Project.getProject().getResourceManager().getAllResources();
            int num = l.size();
            for (int i = 0; i < num; ++i) {
                float f;
                l = Project.getProject().getResourceManager().getAllResources();
                num = l.size();
                resourceIF r = l.get(i);
                Logger.log(this.getClass(), r.getFilename() + " " + r.isLoaded());
                if (r.isLoaded()) continue;
                Logger.log(this.getClass(), "resman loading resource: " + r.getFilename());
                this.loadingbarPercent = f = (float)i / (float)num;
                if (Project.getProject().numResourcesPredicted > 0) {
                    f = (float)i / (float)Project.getProject().numResourcesPredicted;
                }
                Logger.log(this.getClass(), "--------------------------------------------------------------------------" + f);
                bar.render(f);
                r.load();
            }
            this.notifyResourceChangedListeners();
            System.gc();
            return true;
        }
        return false;
    }

    public void removeResource(resourceIF obj) {
        this.resources.remove(obj);
        this.notifyResourceChangedListeners();
    }

    public void notifyResourceChangedListeners() {
        for (ResourcesChangedEvent ev : this.resourcesChangedListeners) {
            ev.resourcesChanged();
        }
    }

    public void addResourcesChangedListener(ResourcesChangedEvent l) {
        this.resourcesChangedListeners.add(l);
    }

    public void removeResourceWhenNotUsed(String filename) {
        resourceIF r = this.getResourceByFileName(filename);
        boolean inuse = false;
        int num = Project.getProject().getNumScenes();
        for (int i = 0; i < num; ++i) {
            SceneIF s = Project.getProject().getScene(i);
            ArrayList<AbstractLine> allLines = s.getAllLines();
            for (int j = 0; j < allLines.size(); ++j) {
                Object[] obs = allLines.get((int)j).plugin.getVariables();
                for (int k = 0; k < obs.length; ++k) {
                    if (!(obs[k] instanceof KeyframedResource)) continue;
                    Logger.log(this.getClass(), "yeah...");
                    KeyframedResource kf = (KeyframedResource)obs[k];
                    if (kf.getResource() != r) continue;
                    JOptionPane.showMessageDialog(main.gui, "resource is in use... (" + allLines.get(j).getTitle() + " in scene " + i + ")");
                    inuse = true;
                }
            }
        }
        if (!inuse) {
            Project.getProject().getResourceManager().removeResource(r);
            this.notifyResourceChangedListeners();
        }
    }

    public void importDragAndDrop(DropTargetDropEvent ev, Transferable tr) {
        try {
            ev.acceptDrop(ev.getDropAction());
            List data = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
            for (Object d : data) {
                File f = (File)d;
                Logger.log(this.getClass(), f.getAbsolutePath());
                Project.getProject().getResourceManager().add(f.getParent() + "/", f.getName());
            }
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
    }
}

