/*
 * Decompiled with CFR 0.152.
 */
package sumo.shader;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.logger.Logger;
import sumo.shader.PartIF;
import sumo.shader.ShaderVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Part
implements PartIF {
    protected String title = "";
    protected String code = "";
    protected String codeFunctions = "";
    protected String headCode = "";
    ArrayList<String> textureNames = new ArrayList();
    int[] textureNums = null;
    public ArrayList<ShaderVariable> uniforms = new ArrayList();
    public ArrayList<ShaderVariable> varyings = new ArrayList();

    Part() {
    }

    public void reload(Element eleShader) {
        try {
            int i;
            this.textureNames = new ArrayList();
            Element eMain = (Element)eleShader.getElementsByTagName("main").item(0);
            this.code = eMain.getTextContent();
            Element eFunc = (Element)eleShader.getElementsByTagName("functions").item(0);
            if (eFunc != null && eFunc.getTextContent() != null) {
                this.codeFunctions = eFunc.getTextContent();
            }
            NodeList uniforms = eleShader.getElementsByTagName("uniform");
            for (int i2 = 0; i2 < uniforms.getLength(); ++i2) {
                String type = ((Element)uniforms.item(i2)).getAttribute("type");
                String name = ((Element)uniforms.item(i2)).getAttribute("name");
                if (type.equals("sampler2DRect")) {
                    this.textureNames.add(name);
                    continue;
                }
                if (this.getUniformVar(name) != null) continue;
                ShaderVariable var = new ShaderVariable(type, name);
                this.uniforms.add(var);
            }
            NodeList nlVarying = eleShader.getElementsByTagName("varying");
            for (i = 0; i < nlVarying.getLength(); ++i) {
                String type = ((Element)nlVarying.item(i)).getAttribute("type");
                String name = ((Element)nlVarying.item(i)).getAttribute("name");
                if (this.getVaryingVar(name) != null) continue;
                ShaderVariable var = new ShaderVariable(type, name);
                this.varyings.add(var);
            }
            if (this.textureNums == null) {
                this.textureNums = new int[this.textureNames.size()];
                for (i = 0; i < this.textureNums.length; ++i) {
                    this.textureNums[i] = 0;
                }
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
    }

    private ShaderVariable getVaryingVar(String name) {
        for (int i = 0; i < this.varyings.size(); ++i) {
            if (!name.equals(this.varyings.get((int)i).name)) continue;
            return this.varyings.get(i);
        }
        return null;
    }

    private ShaderVariable getUniformVar(String name) {
        for (int i = 0; i < this.uniforms.size(); ++i) {
            if (!name.equals(this.uniforms.get((int)i).name)) continue;
            return this.uniforms.get(i);
        }
        return null;
    }

    public void setTextureNum(int which, int slot) {
        this.textureNums[which] = slot;
    }

    public int[] getTextureNums() {
        return this.textureNums;
    }

    public ArrayList<ShaderVariable> getUniforms() {
        return this.uniforms;
    }

    public String getFunctionsCode() {
        if (this.codeFunctions.length() < 6) {
            return "";
        }
        return "\n\r// from: " + this.title + "\n\r" + this.codeFunctions;
    }

    public String getCode(int rand) {
        return "\n\r// from: " + this.title + "\n\rvec4 main_" + this.title + "_" + rand + "(vec4 color){\n\r " + this.code + " \n\rreturn color;\n\r}";
    }

    public String getHeadCode() {
        return this.headCode;
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList<String> getTextureNames() {
        return this.textureNames;
    }

    public ArrayList<ShaderVariable> getVaryings() {
        return this.varyings;
    }
}

