/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.util.ArrayList;
import java.util.List;
import sumo.v3d.BSpline;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.Shadow;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec3f;
import sumo.v3d.mesh.MeshObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene {
    public Vec3f backgroundcolor = new Vec3f();
    public Node rootnode = new Node();
    public ArrayList<Material> materials = new ArrayList();
    public boolean mousecontrolEnabled = false;
    public float animLength = 1.0f;
    public float animStart = 0.0f;
    public float currentTime = 0.0f;
    private int currentCam = -1;
    private boolean shadowed = false;
    public Shadow shadow = null;
    public float lasttime = 0.0f;
    public boolean loop = false;

    public void render(float time) {
        if (this.loop) {
            time = (time - this.animStart) % this.animLength;
        }
        this.lasttime = time;
        if (this.shadowed) {
            if (this.shadow == null) {
                this.shadow = new Shadow(this);
            }
            this.shadow.renderShadow(this, this.rootnode, time, this.getCam(this.getCamNum()));
        } else {
            this.rootnode.render(time);
        }
    }

    public Camera getCam(int value) {
        if (value < 0) {
            return null;
        }
        List<NodeIF> cams = this.rootnode.getChilds(3);
        if (value > cams.size() - 1) {
            return null;
        }
        return (Camera)cams.get(value);
    }

    public void setCam(int which) {
        if (which < 0) {
            return;
        }
        List<NodeIF> cams = this.rootnode.getChilds(3);
        if (which > cams.size() - 1) {
            return;
        }
        this.rootnode.disableChildsByType(3);
        cams.get(which).setEnabled(true);
        this.currentCam = which;
    }

    public NodeIF getCam() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        return cams.get(this.currentCam);
    }

    public int getCamNum() {
        return this.currentCam;
    }

    public int getNumCameras() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        return cams.size();
    }

    public int getNumMeshes() {
        List<NodeIF> cams = this.rootnode.getChilds(1);
        return cams.size();
    }

    public int getNumShapes() {
        List<NodeIF> cams = this.rootnode.getChilds(5);
        return cams.size();
    }

    public List<NodeIF> getMeshObjectNodes() {
        return this.rootnode.getChilds(1);
    }

    public List<MeshObject> getMeshObjects() {
        return this.rootnode.getChildsMeshObjects();
    }

    public List<BSpline> getSplinesStartsWith(String c) {
        List<NodeIF> nodes = this.rootnode.getChilds(5);
        ArrayList<BSpline> ret = new ArrayList<BSpline>();
        for (NodeIF n : nodes) {
            if (!n.getName().contains(c)) continue;
            ret.add((BSpline)n);
        }
        return ret;
    }

    public List<NodeIF> getObjectsByNameContains(String c) {
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        ArrayList<NodeIF> ret = new ArrayList<NodeIF>();
        for (NodeIF n : nodes) {
            if (!n.getName().contains(c)) continue;
            ret.add(n);
        }
        return ret;
    }

    public int getNumLights() {
        List<NodeIF> cams = this.rootnode.getChilds(2);
        return cams.size();
    }

    public int getNumNodes() {
        return this.rootnode.childs.size();
    }

    public String[] getCameraTitles() {
        List<NodeIF> cams = this.rootnode.getChilds(3);
        String[] s = new String[cams.size()];
        for (int i = 0; i < cams.size(); ++i) {
            s[i] = cams.get(i).getName();
        }
        return s;
    }

    public ArrayList<Material> getMaterials() {
        return this.materials;
    }

    public Light getLight() {
        Light l = null;
        List<NodeIF> lights = this.rootnode.getChilds(2);
        if (lights.size() > 0) {
            l = (Light)lights.get(0);
        }
        return l;
    }

    public Light getLightByTitle(String lightTitle) {
        for (Light l : this.getLights()) {
            if (!l.getName().equals(lightTitle)) continue;
            return l;
        }
        return null;
    }

    public Material getMaterialByTitle(String t) {
        for (Material m : this.materials) {
            if (!m.title.equals(t)) continue;
            return m;
        }
        return null;
    }

    public MeshObject getMeshObject(String title) {
        List<MeshObject> nodes = this.rootnode.getChildsMeshObjects();
        if (nodes.size() == 0) {
            return null;
        }
        for (MeshObject n : nodes) {
            if (!n.getName().equals(title)) continue;
            return n;
        }
        return null;
    }

    public NodeIF getMeshObjectNode(String title) {
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        if (nodes.size() == 0) {
            return null;
        }
        for (NodeIF n : nodes) {
            if (!n.getName().equals(title)) continue;
            return n;
        }
        return null;
    }

    public ArrayList<NodeIF> getMeshObjectsStartsWith(String title) {
        ArrayList<NodeIF> meshes = new ArrayList<NodeIF>();
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        for (NodeIF n : nodes) {
            if (!n.getName().startsWith(title)) continue;
            meshes.add(n);
        }
        return meshes;
    }

    public List<Light> getLights() {
        return this.rootnode.getChildsLights();
    }

    public Object[] getHierarchy() {
        Object[] obs = new MeshObject[this.rootnode.childs.size() + 1];
        obs[0] = this.rootnode.getName();
        for (int i = 0; i < this.rootnode.childs.size(); ++i) {
            obs[1 + i] = this.rootnode.childs.get(i).getName();
        }
        return obs;
    }

    public void addChild(NodeIF c) {
        this.rootnode.addChild(c);
    }

    public void createBoundingBoxesAA() {
        List<NodeIF> meshes = this.getMeshObjectNodes();
        for (NodeIF m : meshes) {
            ((MeshObject)m).createBoundingBoxAA();
        }
    }

    public void renderAllBoundingBoxes(boolean b) {
        List<NodeIF> meshes = this.getMeshObjectNodes();
        for (NodeIF m : meshes) {
            ((MeshObject)m).renderBoundingBox = true;
        }
    }

    public void renderBoundingBoxes() {
        List<NodeIF> meshes = this.getMeshObjectNodes();
        for (NodeIF m : meshes) {
            if (!m.getName().contains("barrier")) continue;
            ((MeshObject)m).getBoundingBoxAA().render();
        }
    }

    public int getNumEnabledMeshObjects() {
        List<NodeIF> nodes = this.rootnode.getChilds(1);
        int count = 0;
        for (NodeIF n : nodes) {
            if (!n.getEnabled()) continue;
            ++count;
        }
        return count;
    }

    public void removeNode(MeshObject meshObject) {
        this.rootnode.childs.remove(meshObject);
    }

    public void removeAllMeshObjects() {
        List<NodeIF> meshes = this.getMeshObjectNodes();
        for (NodeIF m : meshes) {
            this.rootnode.childs.remove(m);
        }
    }

    public void setShadows(boolean shad) {
        this.shadowed = shad;
        for (Material m : this.materials) {
            m.settings.forceNoShadow = !shad;
            m.rendererShader.reload();
        }
    }

    public boolean shadowed() {
        return this.shadowed;
    }
}

